/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.config.Property;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.mapping.ReadWSDL;
import org.apache.juddi.v3.client.mapping.Topology;
import org.apache.juddi.v3.client.mapping.UDDIClientSubscriptionListenerImpl;
import org.apache.juddi.v3.client.mapping.URLLocalizer;
import org.apache.juddi.v3.client.mapping.WSDL2UDDI;
import org.apache.juddi.v3.client.transport.TransportException;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.Name;
import org.uddi.sub_v3.Subscription;
import org.uddi.sub_v3.SubscriptionFilter;

public class UDDIServiceCache {
    private Endpoint endpoint = null;
    private String bindingKey = null;
    private String subscriptionKey = null;
    private Log log = LogFactory.getLog(this.getClass());
    private UDDIClerk clerk = null;
    private URLLocalizer urlLocalizer = null;
    private Properties properties = null;
    URL serviceUrl = null;
    private ConcurrentHashMap<String, Topology> serviceLocationMap = new ConcurrentHashMap();
    private static List<String> endpoints = new ArrayList<String>();

    public UDDIClerk getClerk() {
        return this.clerk;
    }

    public void setClerk(UDDIClerk clerk) {
        this.clerk = clerk;
    }

    public UDDIServiceCache(UDDIClerk clerk, URLLocalizer urlLocalizer, Properties properties) throws DatatypeConfigurationException, MalformedURLException, RemoteException, ConfigurationException, WSDLException, TransportException {
        this.clerk = clerk;
        this.urlLocalizer = urlLocalizer;
        this.properties = properties;
        this.subscriptionKey = Property.getSubscriptionKey(properties);
        this.init();
    }

    private void init() throws DatatypeConfigurationException, MalformedURLException, WSDLException, RemoteException, ConfigurationException, TransportException {
        QName serviceQName = new QName("urn:uddi-org:v3_service", "UDDIClientSubscriptionListenerService");
        String portName = "UDDIClientSubscriptionListenerImplPort";
        String url = this.urlLocalizer.rewrite(new URL("http://localhost:8080/subscriptionlistener_" + this.clerk.getManagerName()));
        if (!endpoints.contains(url)) {
            endpoints.add(url);
            this.serviceUrl = new URL(url);
            this.log.info((Object)("Bring up Subscription Listener for manager " + this.clerk.getManagerName() + " with endpoint " + url));
            this.bindingKey = Property.getBindingKey(this.properties, serviceQName, portName, this.serviceUrl);
            this.endpoint = Endpoint.create((Object)new UDDIClientSubscriptionListenerImpl(this.bindingKey, this));
            this.endpoint.publish(this.serviceUrl.toExternalForm());
            WSDL2UDDI wsdl2UDDI = new WSDL2UDDI(this.clerk, this.urlLocalizer, this.properties);
            Definition wsdlDefinition = new ReadWSDL().readWSDL("juddi_client_subscriptionlistener.wsdl");
            this.bindingKey = wsdl2UDDI.register(serviceQName, portName, this.serviceUrl, wsdlDefinition).getBindingKey();
            this.registerSubscription();
        }
    }

    public void shutdown() throws RemoteException, ConfigurationException, TransportException {
        this.unRegisterSubscription();
        QName serviceQName = new QName("urn:uddi-org:v3_service", "UDDIClientSubscriptionListenerService");
        String portName = "UDDIClientSubscriptionListenerImplPort";
        WSDL2UDDI wsdl2UDDI = new WSDL2UDDI(this.clerk, this.urlLocalizer, this.properties);
        wsdl2UDDI.unRegister(serviceQName, portName, this.serviceUrl);
        this.endpoint.stop();
        endpoints.remove(this.serviceUrl.toExternalForm());
        UDDIClientSubscriptionListenerImpl.getServiceCacheMap().remove(this.bindingKey);
    }

    public void removeAll() {
        this.log.info((Object)("Flushing the client side " + this.clerk.getManagerName() + " UDDIServiceCache "));
        for (String key : this.serviceLocationMap.keySet()) {
            this.serviceLocationMap.get(key);
        }
    }

    public void addService(String serviceKey, Topology topology) {
        this.serviceLocationMap.put(serviceKey, topology);
    }

    public Topology lookupService(String serviceKey) {
        return this.serviceLocationMap.get(serviceKey);
    }

    public void removeService(String serviceKey) {
        this.serviceLocationMap.remove(serviceKey);
    }

    public void registerSubscription() throws DatatypeConfigurationException {
        FindService findAllServices = new FindService();
        FindQualifiers qualifiers = new FindQualifiers();
        qualifiers.getFindQualifier().add("approximateMatch");
        findAllServices.setFindQualifiers(qualifiers);
        Name name = new Name();
        name.setValue("%");
        findAllServices.getName().add(name);
        SubscriptionFilter filter = new SubscriptionFilter();
        filter.setFindService(findAllServices);
        Subscription subscription = new Subscription();
        subscription.setSubscriptionFilter(filter);
        subscription.setBindingKey(this.bindingKey);
        subscription.setBrief(Boolean.valueOf(true));
        Duration oneMinute = DatatypeFactory.newInstance().newDuration("PT1M");
        subscription.setNotificationInterval(oneMinute);
        subscription.setSubscriptionKey(this.subscriptionKey);
        this.clerk.register(subscription);
    }

    public void unRegisterSubscription() {
        this.clerk.unRegisterSubscription(this.subscriptionKey);
    }
}

