/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.util.Set;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.weld.injection.WeldManagedReference;
import org.jboss.as.weld.injection.WeldManagedReferenceFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public class WeldInjectionInterceptor
implements Interceptor {
    private final WeldManagedReferenceFactory weldManagedReferenceFactory;
    private final Set<Class<?>> interceptorClasses;

    public WeldInjectionInterceptor(WeldManagedReferenceFactory weldManagedReferenceFactory, Set<Class<?>> interceptorClasses) {
        this.weldManagedReferenceFactory = weldManagedReferenceFactory;
        this.interceptorClasses = interceptorClasses;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        ComponentInstance componentInstance = (ComponentInstance)context.getPrivateData(ComponentInstance.class);
        ManagedReference managedReference = (ManagedReference)componentInstance.getInstanceData(BasicComponentInstance.INSTANCE_KEY);
        if (managedReference instanceof WeldManagedReference) {
            WeldManagedReference reference = (WeldManagedReference)managedReference;
            reference.getInjectionTarget().inject(managedReference.getInstance(), reference.getContext());
            for (Class<?> interceptorClass : this.interceptorClasses) {
                ManagedReference instance = (ManagedReference)componentInstance.getInstanceData(interceptorClass);
                if (instance == null) continue;
                reference.injectInterceptor(interceptorClass, instance.getInstance());
            }
        } else if (this.weldManagedReferenceFactory != null) {
            ManagedReference newReference = this.weldManagedReferenceFactory.injectExistingReference(managedReference);
            componentInstance.setInstanceData(BasicComponentInstance.INSTANCE_KEY, (Object)newReference);
        }
        return context.proceed();
    }
}

