/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management;

import javax.security.auth.login.LoginException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="JBAS")
public interface DomainManagementLogger
extends BasicLogger {
    public static final DomainManagementLogger ROOT_LOGGER = (DomainManagementLogger)Logger.getMessageLogger(DomainManagementLogger.class, (String)DomainManagementLogger.class.getPackage().getName());
    public static final DomainManagementLogger SECURITY_LOGGER = (DomainManagementLogger)Logger.getMessageLogger(DomainManagementLogger.class, (String)(DomainManagementLogger.class.getPackage().getName() + ".security"));

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15200, value="Properties file defined with default user and password, this will be easy to guess.")
    public void userAndPasswordWarning();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15201, value="Whitespace has been trimmed from the Base64 representation of the secret identity.")
    public void whitespaceTrimmed();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15202, value="The attribute 'password' is deprecated, 'keystore-password' should be used instead.")
    public void passwordAttributeDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15203, value="The realm name of the defined security realm '%s' does not match the realm name within the properties file '%s'.")
    public void realmMisMatch(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15204, value="Failed to retrieving groups from the LDAP provider.")
    public void failedRetrieveLdapGroups(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15205, value="Failed to retrieving matching groups from the pattern, check the regular expression for pattern attribute.")
    public void failedRetrieveMatchingLdapGroups(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15206, value="Failed to retrieve matching groups from the groups, check the regular expression for groups attribute.")
    public void failedRetrieveMatchingGroups();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15207, value="Failed to retrieve attribute %s from search result.")
    public void failedRetrieveLdapAttribute(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15208, value="Login failed using Keytab for principal '%s' to handle request for host '%s'")
    public void keytabLoginFailed(String var1, String var2, @Cause LoginException var3);
}

