/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.domain.http.server.DmrFailureReadinessFilter;
import org.jboss.as.domain.http.server.DomainApiCheckHandler;
import org.jboss.as.domain.http.server.DomainApiUploadHandler;
import org.jboss.as.domain.http.server.DomainUtil;
import org.jboss.as.domain.http.server.ErrorHandler;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.as.domain.http.server.ManagementHttpHandler;
import org.jboss.as.domain.http.server.multipart.BoundaryDelimitedInputStream;
import org.jboss.as.domain.http.server.multipart.MimeHeaderParser;
import org.jboss.as.domain.management.AuthenticationMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.Authenticator;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpContext;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.com.sun.net.httpserver.HttpServer;
import org.jboss.dmr.ModelNode;

class DomainApiHandler
implements ManagementHttpHandler {
    private static final String DOMAIN_API_CONTEXT = "/management";
    private static final String ADD_CONTENT_REQUEST = "/management/add-content";
    private static Pattern MULTIPART_FD_BOUNDARY = Pattern.compile("^multipart/form-data.*;\\s*boundary=(.*)$");
    private static Pattern DISPOSITION_FILE = Pattern.compile("^form-data.*filename=\"?([^\"]*)?\"?.*$");
    private static final String JSON_PRETTY = "json.pretty";
    private static final String USE_STREAM_AS_RESPONSE = "useStreamAsResponse";
    private static final String USE_STREAM_AS_RESPONSE_HEADER = "org.wildfly.useStreamAsResponse";
    private final Authenticator authenticator;
    private final ControlledProcessStateService controlledProcessStateService;
    private ModelController modelController;

    DomainApiHandler(ModelController modelController, Authenticator authenticator, ControlledProcessStateService controlledProcessStateService) {
        this.modelController = modelController;
        this.authenticator = authenticator;
        this.controlledProcessStateService = controlledProcessStateService;
    }

    private void doHandle(HttpExchange http) throws IOException {
        String requestMethod = http.getRequestMethod();
        URI request = http.getRequestURI();
        boolean uploadRequest = ADD_CONTENT_REQUEST.equals(request.getPath());
        if ("POST".equals(requestMethod)) {
            if (uploadRequest) {
                this.processUploadRequest(http);
                return;
            }
            Headers headers = http.getRequestHeaders();
            String contentType = this.extractContentType(headers.getFirst("Content-Type"));
            if (!"application/json".equals(contentType) && !"application/dmr-encoded".equals(contentType)) {
                this.drain(http);
                HttpServerLogger.ROOT_LOGGER.debug("Request rejected due to unsupported media type - should be one of (application/json,application/dmr-encoded).");
                this.sendResponse(http, 415, contentType + "\n");
                return;
            }
        }
        this.processRequest(http);
    }

    public void handle(HttpExchange exchange) throws IOException {
        try {
            this.doHandle(exchange);
        }
        catch (Exception e) {
            this.sendResponse(exchange, 500, e.getMessage() + "\n");
        }
    }

    private void drain(HttpExchange exchange) throws IOException {
        try {
            exchange.getRequestBody().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String extractContentType(String fullContentType) {
        int pos = fullContentType.indexOf(59);
        return pos < 0 ? fullContentType : fullContentType.substring(0, pos).trim();
    }

    private void processUploadRequest(HttpExchange http) throws IOException {
        ModelNode response = null;
        try {
            SeekResult result = this.seekToDeployment(http);
            ModelNode dmr = new ModelNode();
            dmr.get(new String[]{"operation-headers", "access-mechanism"}).set(AccessMechanism.HTTP.toString());
            dmr.get("operation").set("upload-deployment-stream");
            dmr.get("address").setEmptyList();
            dmr.get("input-stream-index").set(0);
            OperationBuilder operation = new OperationBuilder(dmr);
            operation.addInputStream((InputStream)result.stream);
            response = this.modelController.execute(dmr, OperationMessageHandler.DISCARD, ModelController.OperationTransactionControl.COMMIT, (OperationAttachments)operation.build());
            this.drain(http.getRequestBody());
        }
        catch (Throwable t) {
            HttpServerLogger.ROOT_LOGGER.uploadError(t);
            this.sendError(http, false, t);
            return;
        }
        DomainUtil.writeResponse(http, false, false, response, 200, false, "text/html");
    }

    private void processRequest(final HttpExchange http) throws IOException {
        OperationResponse response;
        ModelNode dmr;
        Map<String, String> queryParameters;
        URI request = http.getRequestURI();
        String requestMethod = http.getRequestMethod();
        final boolean isGet = "GET".equals(requestMethod);
        if (!isGet && !"POST".equals(requestMethod)) {
            HttpServerLogger.ROOT_LOGGER.debug("Request rejected as method not one of (GET,POST).");
            http.sendResponseHeaders(405, -1L);
            return;
        }
        Headers requestHeaders = http.getRequestHeaders();
        final boolean encode = "application/dmr-encoded".equals(requestHeaders.getFirst("Accept")) || "application/dmr-encoded".equals(requestHeaders.getFirst("Content-Type"));
        try {
            queryParameters = DomainApiHandler.decodeQuery(request.getRawQuery());
            dmr = isGet ? this.convertGetRequest(request, queryParameters) : this.convertPostRequest(http.getRequestBody(), encode);
        }
        catch (Exception iae) {
            HttpServerLogger.ROOT_LOGGER.debugf("Unable to construct ModelNode '%s'", iae.getMessage());
            this.sendError(http, isGet, iae);
            return;
        }
        final int streamIndex = DomainApiHandler.getStreamIndex(requestHeaders, queryParameters);
        final boolean pretty = dmr.hasDefined(JSON_PRETTY) && dmr.get(JSON_PRETTY).asBoolean();
        final ResponseCallback callback = new ResponseCallback(){

            @Override
            void doSendResponse(OperationResponse response) {
                DomainApiHandler.this.sendResponse(http, response, isGet, pretty, encode, streamIndex);
            }
        };
        boolean sendPreparedResponse = this.sendPreparedResponse(dmr);
        ModelController.OperationTransactionControl control = sendPreparedResponse ? new ModelController.OperationTransactionControl(){

            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                transaction.commit();
                result.get("outcome").set("success");
                result.get("result");
                callback.sendResponse(OperationResponse.Factory.createSimple((ModelNode)result));
            }
        } : ModelController.OperationTransactionControl.COMMIT;
        try {
            dmr.get(new String[]{"operation-headers", "access-mechanism"}).set(AccessMechanism.HTTP.toString());
            response = this.modelController.execute(Operation.Factory.create((ModelNode)dmr), OperationMessageHandler.DISCARD, control);
        }
        catch (Throwable t) {
            HttpServerLogger.ROOT_LOGGER.modelRequestError(t);
            this.sendError(http, isGet, t);
            return;
        }
        if (!sendPreparedResponse) {
            this.sendResponse(http, response, isGet, pretty, encode, streamIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(HttpExchange http, OperationResponse response, boolean isGet, boolean pretty, boolean encode, int streamIndex) {
        try {
            ModelNode responseNode = response.getResponseNode();
            if (responseNode.hasDefined("outcome") && "failed".equals(responseNode.get("outcome").asString())) {
                int status = DomainApiHandler.getErrorResponseCode(responseNode.asString());
                DomainUtil.writeResponse(http, isGet, pretty, responseNode, status, encode);
                return;
            }
            if (streamIndex < 0) {
                DomainUtil.writeResponse(http, isGet, pretty, responseNode, 200, encode);
            } else {
                List streamEntries = response.getInputStreams();
                if (streamIndex >= streamEntries.size()) {
                    ModelNode error = new ModelNode(HttpServerMessages.MESSAGES.invalidUseStreamAsResponseIndex(streamIndex, streamEntries.size()));
                    DomainUtil.writeResponse(http, isGet, true, error, 400, false);
                } else {
                    DomainUtil.writeResponse(http, response, streamIndex);
                }
            }
        }
        catch (IOException e) {
            HttpServerLogger.ROOT_LOGGER.responseFailed(e);
        }
        finally {
            DomainUtil.safeClose((Closeable)response);
        }
    }

    private void sendError(HttpExchange http, boolean isGet, Throwable t) throws IOException {
        this.sendError(http, isGet, t.getMessage());
    }

    private void sendError(HttpExchange http, boolean isGet, String message) throws IOException {
        ModelNode response = new ModelNode(message);
        DomainUtil.writeResponse(http, isGet, true, response, 500, false);
    }

    private static int getStreamIndex(Headers requestHeaders, Map<String, String> queryParams) {
        int result = DomainApiHandler.getStreamIndex(requestHeaders.get((Object)USE_STREAM_AS_RESPONSE_HEADER));
        if (result == -1) {
            String value = queryParams.get(USE_STREAM_AS_RESPONSE);
            result = DomainApiHandler.getStreamIndex(value == null ? null : Collections.singletonList(value));
        }
        return result;
    }

    private static int getStreamIndex(List<String> holder) {
        String val;
        int result = holder != null ? (holder.size() > 0 && (val = holder.get(0)).length() > 0 ? ("true".equalsIgnoreCase(val) ? 0 : Integer.parseInt(val)) : 0) : -1;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(HttpExchange exchange, int responseCode, String body) throws IOException {
        exchange.sendResponseHeaders(responseCode, 0L);
        PrintWriter out = new PrintWriter(exchange.getResponseBody());
        try {
            out.print(body);
            out.flush();
        }
        finally {
            DomainUtil.safeClose(out);
        }
    }

    private SeekResult seekToDeployment(HttpExchange http) throws IOException {
        String type = http.getRequestHeaders().getFirst("Content-Type");
        if (type == null) {
            throw HttpServerMessages.MESSAGES.invalidContentType();
        }
        Matcher matcher = MULTIPART_FD_BOUNDARY.matcher(type);
        if (!matcher.matches()) {
            throw HttpServerMessages.MESSAGES.invalidContentType(type);
        }
        String boundary = "--" + matcher.group(1);
        BoundaryDelimitedInputStream stream = new BoundaryDelimitedInputStream(http.getRequestBody(), boundary.getBytes("US-ASCII"));
        byte[] ignore = new byte[1024];
        while (stream.read(ignore) != -1) {
        }
        stream.setBoundary(("\r\n" + boundary).getBytes("US-ASCII"));
        while (!stream.isOuterStreamClosed()) {
            MimeHeaderParser.ParseResult result = MimeHeaderParser.parseHeaders(stream);
            if (result.eof()) continue;
            Headers partHeaders = result.headers();
            String disposition = partHeaders.getFirst("Content-Disposition");
            if (disposition != null && (matcher = DISPOSITION_FILE.matcher(disposition)).matches()) {
                SeekResult seek = new SeekResult();
                seek.stream = stream;
                return seek;
            }
            while (stream.read(ignore) != -1) {
            }
        }
        throw HttpServerMessages.MESSAGES.invalidDeployment();
    }

    private void drain(InputStream stream) {
        try {
            byte[] ignore = new byte[1024];
            while (stream.read(ignore) != -1) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private ModelNode convertPostRequest(InputStream stream, boolean encode) throws IOException {
        return encode ? ModelNode.fromBase64((InputStream)stream) : ModelNode.fromJSONStream((InputStream)stream);
    }

    private ModelNode convertGetRequest(URI request, Map<String, String> queryParameters) {
        ArrayList<String> pathSegments = this.decodePath(request.getRawPath());
        GetOperation operation = null;
        ModelNode dmr = new ModelNode();
        for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
            ModelNode valueNode;
            String key = entry.getKey();
            String value = entry.getValue();
            if ("operation".equals(key)) {
                try {
                    operation = GetOperation.valueOf(value.toUpperCase(Locale.ENGLISH).replace('-', '_'));
                    value = operation.realOperation();
                    valueNode = dmr.get(key);
                }
                catch (Exception e) {
                    throw HttpServerMessages.MESSAGES.invalidOperation(e, value);
                }
            } else if (key.startsWith("operation-header-")) {
                String header = key.substring("operation-header-".length());
                valueNode = dmr.get(new String[]{"operation-headers", header});
            } else {
                valueNode = dmr.get(key);
            }
            valueNode.set(value);
        }
        if (operation == null) {
            operation = GetOperation.RESOURCE;
            dmr.get("operation").set(operation.realOperation);
        }
        if (operation == GetOperation.RESOURCE && !dmr.has("recursive")) {
            dmr.get("recursive").set(false);
        }
        ModelNode list = dmr.get("address").setEmptyList();
        for (int i = 1; i < pathSegments.size() - 1; i += 2) {
            list.add(pathSegments.get(i), pathSegments.get(i + 1));
        }
        return dmr;
    }

    private ArrayList<String> decodePath(String path) {
        int j;
        if (path == null) {
            throw new IllegalArgumentException();
        }
        int i = path.charAt(0) == '/' ? 1 : 0;
        ArrayList<String> segments = new ArrayList<String>();
        do {
            if ((j = path.indexOf(47, i)) == -1) {
                j = path.length();
            }
            segments.add(DomainApiHandler.unescape(path.substring(i, j)));
        } while ((i = j + 1) < path.length());
        return segments;
    }

    private static String unescape(String string) {
        try {
            return URLDecoder.decode(string, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    static Map<String, String> decodeQuery(String query) {
        int j;
        if (query == null || query.isEmpty()) {
            return Collections.emptyMap();
        }
        int i = 0;
        HashMap<String, String> parameters = new HashMap<String, String>();
        do {
            String value;
            String key;
            String pair;
            int k;
            if ((j = query.indexOf(38, i)) == -1) {
                j = query.length();
            }
            if ((k = (pair = query.substring(i, j)).indexOf(61)) == -1) {
                key = DomainApiHandler.unescape(pair);
                value = "true";
            } else {
                key = DomainApiHandler.unescape(pair.substring(0, k));
                value = DomainApiHandler.unescape(pair.substring(k + 1, pair.length()));
            }
            parameters.put(key, value);
        } while ((i = j + 1) < query.length());
        return parameters;
    }

    @Override
    public void start(HttpServer httpServer, SecurityRealm securityRealm) {
        HttpContext context = httpServer.createContext(DOMAIN_API_CONTEXT, (HttpHandler)new DomainApiCheckHandler(this, this.controlledProcessStateService));
        this.addAuthenticator(this.authenticator, context, securityRealm);
        HttpContext upload = httpServer.createContext("/management-upload", (HttpHandler)new DomainApiCheckHandler(new DomainApiUploadHandler(this.modelController), this.controlledProcessStateService));
        this.addAuthenticator(this.authenticator, upload, securityRealm);
    }

    protected void addAuthenticator(Authenticator authenticator, HttpContext context, SecurityRealm securityRealm) {
        if (authenticator != null) {
            context.setAuthenticator(authenticator);
            List filters = context.getFilters();
            if (securityRealm != null && !securityRealm.getSupportedAuthenticationMechanisms().contains(AuthenticationMechanism.CLIENT_CERT)) {
                filters.add(new DmrFailureReadinessFilter(securityRealm, ErrorHandler.getRealmRedirect()));
            }
        }
    }

    @Override
    public void stop(HttpServer httpServer) {
        httpServer.removeContext(DOMAIN_API_CONTEXT);
        this.modelController = null;
    }

    private static int getErrorResponseCode(String failureMsg) {
        int result = 500;
        if (failureMsg != null && failureMsg.contains("JBAS013456")) {
            result = 403;
        }
        return result;
    }

    private boolean sendPreparedResponse(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String op = operation.get("operation").asString();
        int size = address.size();
        if (size == 0) {
            if (op.equals("reload")) {
                return true;
            }
            if (op.equals("composite")) {
                return false;
            }
            return false;
        }
        if (size == 1 && address.getLastElement().getKey().equals("host")) {
            return op.equals("reload");
        }
        return false;
    }

    private static abstract class ResponseCallback {
        private volatile boolean complete;

        private ResponseCallback() {
        }

        void sendResponse(OperationResponse response) {
            if (this.complete) {
                return;
            }
            this.complete = true;
            this.doSendResponse(response);
        }

        abstract void doSendResponse(OperationResponse var1);
    }

    private static final class SeekResult {
        BoundaryDelimitedInputStream stream;

        private SeekResult() {
        }
    }

    static enum GetOperation {
        RESOURCE("read-resource"),
        ATTRIBUTE("read-attribute"),
        RESOURCE_DESCRIPTION("read-resource-description"),
        SNAPSHOTS("list-snapshots"),
        OPERATION_DESCRIPTION("read-operation-description"),
        OPERATION_NAMES("read-operation-names");

        private String realOperation;

        private GetOperation(String realOperation) {
            this.realOperation = realOperation;
        }

        public String realOperation() {
            return this.realOperation;
        }
    }
}

