/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.IOException;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.security.SubjectAssociationHandler;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.com.sun.net.httpserver.HttpsServer;

public class DomainApiCheckHandler
implements HttpHandler {
    private final ControlledProcessStateService controlledProcessStateService;
    private final HttpHandler wrapped;

    public DomainApiCheckHandler(HttpHandler wrapped, ControlledProcessStateService controlledProcessStateService) {
        this.controlledProcessStateService = controlledProcessStateService;
        this.wrapped = new SubjectAssociationHandler(wrapped);
    }

    public void handle(HttpExchange exchange) throws IOException {
        if (!this.commonChecks(exchange)) {
            return;
        }
        this.wrapped.handle(exchange);
    }

    protected boolean commonChecks(HttpExchange http) throws IOException {
        ControlledProcessState.State currentState = this.controlledProcessStateService.getCurrentState();
        if (currentState == ControlledProcessState.State.STARTING || currentState == ControlledProcessState.State.STOPPING) {
            http.getResponseHeaders().add("Retry-After", "2");
            http.sendResponseHeaders(503, -1L);
            return false;
        }
        String requestMethod = http.getRequestMethod();
        if ("OPTIONS".equals(requestMethod)) {
            DomainApiCheckHandler.drain(http);
            HttpServerLogger.ROOT_LOGGER.debug("Request rejected due to 'OPTIONS' method which is not supported.");
            http.sendResponseHeaders(405, -1L);
            return false;
        }
        Headers headers = http.getRequestHeaders();
        if (headers.containsKey((Object)"Origin")) {
            String origin = headers.getFirst("Origin");
            String host = headers.getFirst("Host");
            String protocol = http.getHttpContext().getServer() instanceof HttpsServer ? "https" : "http";
            String allowedOrigin = protocol + "://" + host;
            if (!origin.equals(allowedOrigin)) {
                DomainApiCheckHandler.drain(http);
                HttpServerLogger.ROOT_LOGGER.debug("Request rejected due to HOST/ORIGIN mis-match.");
                http.sendResponseHeaders(403, -1L);
                return false;
            }
        }
        return true;
    }

    static void drain(HttpExchange exchange) throws IOException {
        try {
            exchange.getRequestBody().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

