/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.File;
import org.jboss.dmr.ValueExpression;

public class ValueExpressionResolver {
    public static final ValueExpressionResolver DEFAULT_RESOLVER = new ValueExpressionResolver();
    private static final int INITIAL = 0;
    private static final int GOT_DOLLAR = 1;
    private static final int GOT_OPEN_BRACE = 2;
    private static final int RESOLVED = 3;
    private static final int DEFAULT = 4;

    public String resolve(ValueExpression expression) {
        String value = expression.getExpressionString();
        StringBuilder builder = new StringBuilder();
        int len = value.length();
        int state = 0;
        int start = -1;
        int nest = 0;
        int nameStart = -1;
        String resolvedValue = null;
        int i = 0;
        while (i < len) {
            int ch = value.codePointAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (ch) {
                        case 36: {
                            state = 1;
                            break block0;
                        }
                    }
                    builder.appendCodePoint(ch);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case 36: {
                            builder.appendCodePoint(ch);
                            state = 0;
                            break block0;
                        }
                        case 123: {
                            nameStart = start = i + 1;
                            state = 2;
                            break block0;
                        }
                    }
                    builder.append('$').appendCodePoint(ch);
                    state = 0;
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 123: {
                            ++nest;
                            break;
                        }
                        case 58: {
                            if (nameStart == i) break;
                        }
                        case 44: 
                        case 125: {
                            if (nest > 0) {
                                if (ch != 125) break block0;
                                --nest;
                                break;
                            }
                            String val = this.resolvePart(value.substring(nameStart, i).trim());
                            if (val != null && !val.equals(value)) {
                                builder.append(val);
                                resolvedValue = val;
                                state = ch == 125 ? 0 : 3;
                                break;
                            }
                            if (ch == 44) {
                                nameStart = i + 1;
                                break;
                            }
                            if (ch == 58) {
                                start = i + 1;
                                state = 4;
                                break;
                            }
                            throw new IllegalStateException("Failed to resolve expression: " + value.substring(start - 2, i + 1));
                        }
                    }
                    break;
                }
                case 3: {
                    if (ch == 123) {
                        ++nest;
                        break;
                    }
                    if (ch != 125) break;
                    if (nest > 0) {
                        --nest;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 4: {
                    if (ch == 123) {
                        ++nest;
                        break;
                    }
                    if (ch != 125) break;
                    if (nest > 0) {
                        --nest;
                        break;
                    }
                    state = 0;
                    builder.append(value.substring(start, i));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected char seen: " + ch);
                }
            }
            i = value.offsetByCodePoints(i, 1);
        }
        switch (state) {
            case 1: {
                builder.append('$');
                break;
            }
            case 4: {
                builder.append(value.substring(start - 2));
                break;
            }
            case 2: {
                if (resolvedValue != null) break;
                throw new IllegalStateException("Incomplete expression: " + builder.toString());
            }
        }
        return builder.toString();
    }

    protected String resolvePart(String name) {
        if ("/".equals(name)) {
            return File.separator;
        }
        if (":".equals(name)) {
            return File.pathSeparator;
        }
        String val = System.getProperty(name);
        if (val == null && name.startsWith("env.")) {
            val = System.getenv(name.substring(4));
        }
        return val;
    }
}

