/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.dynamicresource.descriptionproviders.StatisticsDescriptionProvider;
import org.jboss.as.connector.dynamicresource.operations.ClearStatisticsHandler;
import org.jboss.as.connector.subsystems.common.pool.PoolMetrics;
import org.jboss.as.connector.subsystems.common.pool.PoolStatisticsRuntimeAttributeReadHandler;
import org.jboss.as.connector.subsystems.common.pool.PoolStatisticsRuntimeAttributeWriteHandler;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;

public class DataSourceStatisticsListener
extends AbstractServiceListener<Object> {
    private static final PathElement JDBC_STATISTICS = PathElement.pathElement((String)"statistics", (String)"jdbc");
    private static final PathElement POOL_STATISTICS = PathElement.pathElement((String)"statistics", (String)"pool");
    private final ManagementResourceRegistration registration;
    private final String dsName;
    private final boolean statsEnabled;

    public DataSourceStatisticsListener(ManagementResourceRegistration overrideRegistration, String dsName, boolean statsEnabled) {
        this.registration = overrideRegistration;
        this.dsName = dsName;
        this.statsEnabled = statsEnabled;
    }

    public void transition(ServiceController<?> controller, ServiceController.Transition transition) {
        switch (transition) {
            case STARTING_to_UP: {
                PoolStatisticsRuntimeAttributeWriteHandler writeHandler;
                PoolStatisticsRuntimeAttributeReadHandler readHandler;
                ManagementResourceRegistration subRegistration;
                CommonDeployment deploymentMD = ((AbstractDataSourceService)controller.getService()).getDeploymentMD();
                StatisticsPlugin jdbcStats = deploymentMD.getDataSources()[0].getStatistics();
                PoolStatistics poolStats = deploymentMD.getDataSources()[0].getPool().getStatistics();
                jdbcStats.setEnabled(this.statsEnabled);
                poolStats.setEnabled(this.statsEnabled);
                int jdbcStatsSize = jdbcStats.getNames().size();
                int poolStatsSize = poolStats.getNames().size();
                if (jdbcStatsSize <= 0 && poolStatsSize <= 0) break;
                ManagementResourceRegistration managementResourceRegistration = subRegistration = this.registration.isAllowsOverride() ? this.registration.registerOverrideModel(this.dsName, DataSourcesSubsystemProviders.OVERRIDE_DS_DESC) : this.registration;
                if (jdbcStatsSize > 0) {
                    ManagementResourceRegistration jdbcRegistration = subRegistration.registerSubModel(JDBC_STATISTICS, (DescriptionProvider)new StatisticsDescriptionProvider(DataSourcesSubsystemProviders.RESOURCE_NAME, "statistics", jdbcStats));
                    jdbcRegistration.setRuntimeOnly(true);
                    jdbcRegistration.registerOperationHandler((OperationDefinition)Constants.CLEAR_STATISTICS, (OperationStepHandler)new ClearStatisticsHandler(jdbcStats));
                    for (String statName : jdbcStats.getNames()) {
                        jdbcRegistration.registerMetric(statName, (OperationStepHandler)new PoolMetrics.ParametrizedPoolMetricsHandler(jdbcStats));
                    }
                    readHandler = new PoolStatisticsRuntimeAttributeReadHandler(jdbcStats);
                    writeHandler = new PoolStatisticsRuntimeAttributeWriteHandler(jdbcStats);
                    jdbcRegistration.registerReadWriteAttribute((AttributeDefinition)org.jboss.as.connector.subsystems.common.pool.Constants.POOL_STATISTICS_ENABLED, (OperationStepHandler)readHandler, (OperationStepHandler)writeHandler);
                }
                if (poolStatsSize <= 0) break;
                ManagementResourceRegistration poolRegistration = subRegistration.registerSubModel(POOL_STATISTICS, (DescriptionProvider)new StatisticsDescriptionProvider(DataSourcesSubsystemProviders.RESOURCE_NAME, "statistics", new StatisticsPlugin[]{poolStats}));
                poolRegistration.setRuntimeOnly(true);
                poolRegistration.registerOperationHandler((OperationDefinition)Constants.CLEAR_STATISTICS, (OperationStepHandler)new ClearStatisticsHandler(new StatisticsPlugin[]{poolStats}));
                for (String statName : poolStats.getNames()) {
                    poolRegistration.registerMetric(statName, (OperationStepHandler)new PoolMetrics.ParametrizedPoolMetricsHandler((StatisticsPlugin)poolStats));
                }
                readHandler = new PoolStatisticsRuntimeAttributeReadHandler((StatisticsPlugin)poolStats);
                writeHandler = new PoolStatisticsRuntimeAttributeWriteHandler((StatisticsPlugin)poolStats);
                poolRegistration.registerReadWriteAttribute((AttributeDefinition)org.jboss.as.connector.subsystems.common.pool.Constants.POOL_STATISTICS_ENABLED, (OperationStepHandler)readHandler, (OperationStepHandler)writeHandler);
                break;
            }
            case UP_to_STOP_REQUESTED: {
                ManagementResourceRegistration subRegistration = this.registration.getOverrideModel(this.dsName);
                if (subRegistration == null) break;
                subRegistration.unregisterSubModel(JDBC_STATISTICS);
                subRegistration.unregisterSubModel(POOL_STATISTICS);
                this.registration.unregisterOverrideModel(this.dsName);
                break;
            }
        }
    }

    public static void registerStatisticsResources(Resource datasourceResource) {
        if (!datasourceResource.hasChild(JDBC_STATISTICS)) {
            datasourceResource.registerChild(JDBC_STATISTICS, (Resource)new PlaceholderResource.PlaceholderResourceEntry(JDBC_STATISTICS));
        }
        if (!datasourceResource.hasChild(POOL_STATISTICS)) {
            datasourceResource.registerChild(POOL_STATISTICS, (Resource)new PlaceholderResource.PlaceholderResourceEntry(POOL_STATISTICS));
        }
    }

    public static void removeStatisticsResources(Resource datasourceResource) {
        if (datasourceResource.hasChild(JDBC_STATISTICS)) {
            datasourceResource.removeChild(JDBC_STATISTICS);
        }
        if (datasourceResource.hasChild(POOL_STATISTICS)) {
            datasourceResource.removeChild(POOL_STATISTICS);
        }
    }
}

