/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.datasource;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.LocalDataSourceService;
import org.jboss.as.connector.subsystems.datasources.ModifiableDataSource;
import org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.v11.DsPool;
import org.jboss.jca.common.api.metadata.ds.v11.DsXaPool;
import org.jboss.jca.common.metadata.ds.DsSecurityImpl;
import org.jboss.jca.common.metadata.ds.v11.DsPoolImpl;
import org.jboss.jca.common.metadata.ds.v11.DsXaPoolImpl;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;

public class DirectDataSourceInjectionSource
extends InjectionSource {
    public static final String USER_PROP = "user";
    public static final String URL_PROP = "url";
    public static final String UPPERCASE_URL_PROP = "URL";
    public static final String TRANSACTIONAL_PROP = "transactional";
    public static final String SERVER_NAME_PROP = "serverName";
    public static final String PROPERTIES_PROP = "properties";
    public static final String PORT_NUMBER_PROP = "portNumber";
    public static final String PASSWORD_PROP = "password";
    public static final String MIN_POOL_SIZE_PROP = "minPoolSize";
    public static final String MAX_STATEMENTS_PROP = "maxStatements";
    public static final String MAX_IDLE_TIME_PROP = "maxIdleTime";
    public static final String LOGIN_TIMEOUT_PROP = "loginTimeout";
    public static final String ISOLATION_LEVEL_PROP = "isolationLevel";
    public static final String INITIAL_POOL_SIZE_PROP = "initialPoolSize";
    public static final String DESCRIPTION_PROP = "description";
    public static final String DATABASE_NAME_PROP = "databaseName";
    public static final String MAX_POOL_SIZE_PROP = "maxPoolSize";
    private final String jndiName;
    private String className;
    private String description;
    private String url;
    private String databaseName;
    private String serverName;
    private int portNumber = -1;
    private int loginTimeout = -1;
    private int isolationLevel = -1;
    private boolean transactional = true;
    private int initialPoolSize = -1;
    private int maxIdleTime = -1;
    private int maxPoolSize = -1;
    private int maxStatements = -1;
    private int minPoolSize = -1;
    private String user;
    private String password;
    private String[] properties;

    public DirectDataSourceInjectionSource(String jndiName) {
        this.jndiName = jndiName;
    }

    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        String poolName = this.uniqueName(context, this.jndiName);
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        try {
            Class clazz = module.getClassLoader().loadClass(this.className);
            HashMap<String, String> props = new HashMap<String, String>();
            if (this.properties != null) {
                for (String prop : this.properties) {
                    if (prop.contains("=")) {
                        int index = prop.indexOf(61);
                        String name = prop.substring(0, index);
                        String value = prop.substring(index + 1, prop.length());
                        props.put(name, value);
                        continue;
                    }
                    props.put(prop, "");
                }
            }
            this.clearUnkownProperties(reflectionIndex, clazz, props);
            this.populateProperties(reflectionIndex, clazz, props);
            DsSecurityImpl dsSecurity = new DsSecurityImpl(this.user, this.password, null, null);
            if (XADataSource.class.isAssignableFrom(clazz) && this.transactional) {
                DsXaPoolImpl xaPool = new DsXaPoolImpl(Integer.valueOf(this.minPoolSize < 1 ? Defaults.MIN_POOL_SIZE : this.minPoolSize), Integer.valueOf(this.maxPoolSize < 1 ? Defaults.MAX_POOL_SIZE : this.maxPoolSize), Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY, Defaults.IS_SAME_RM_OVERRIDE, Defaults.INTERLEAVING, Defaults.PAD_XID, Defaults.WRAP_XA_RESOURCE, Defaults.NO_TX_SEPARATE_POOL, Boolean.valueOf(false));
                ModifiableXaDataSource dataSource = new ModifiableXaDataSource(this.transactionIsolation(), null, (DsSecurity)dsSecurity, null, null, null, null, null, poolName, true, this.jndiName, false, false, props, this.className, null, null, (DsXaPool)xaPool, null);
                XaDataSourceService xds = new XaDataSourceService(this.jndiName, (ClassLoader)module.getClassLoader());
                xds.getDataSourceConfigInjector().inject((Object)dataSource);
                this.startDataSource(xds, this.jndiName, eeModuleDescription, context, phaseContext.getServiceTarget(), serviceBuilder, injector);
            } else {
                DsPoolImpl commonPool = new DsPoolImpl(Integer.valueOf(this.minPoolSize < 1 ? Defaults.MIN_POOL_SIZE : this.minPoolSize), Integer.valueOf(this.maxPoolSize < 1 ? Defaults.MAX_POOL_SIZE : this.maxPoolSize), Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY, Boolean.valueOf(false));
                ModifiableDataSource dataSource = new ModifiableDataSource(this.url, null, this.className, null, this.transactionIsolation(), props, null, (DsSecurity)dsSecurity, null, null, null, null, null, false, poolName, true, this.jndiName, Defaults.SPY, Defaults.USE_CCM, this.transactional, Defaults.CONNECTABLE, (DsPool)commonPool);
                LocalDataSourceService ds = new LocalDataSourceService(this.jndiName, (ClassLoader)module.getClassLoader());
                ds.getDataSourceConfigInjector().inject((Object)dataSource);
                this.startDataSource(ds, this.jndiName, eeModuleDescription, context, phaseContext.getServiceTarget(), serviceBuilder, injector);
            }
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private void clearUnkownProperties(DeploymentReflectionIndex reflectionIndex, Class<?> dataSourceClass, Map<String, String> props) {
        Iterator<Map.Entry<String, String>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Class<?> paramType;
            Map.Entry<String, String> entry = it.next();
            String value = entry.getKey();
            if (value == null || "".equals(value)) {
                it.remove();
                continue;
            }
            StringBuilder builder = new StringBuilder("set").append(entry.getKey());
            builder.setCharAt(3, Character.toUpperCase(entry.getKey().charAt(0)));
            String methodName = builder.toString();
            MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[]{paramType = value.getClass()});
            Method setterMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)reflectionIndex, dataSourceClass, (MethodIdentifier)methodIdentifier);
            if (setterMethod != null) continue;
            it.remove();
            ConnectorLogger.DS_DEPLOYER_LOGGER.methodNotFoundOnDataSource(methodName, dataSourceClass);
        }
    }

    private String uniqueName(InjectionSource.ResolutionContext context, String jndiName) {
        StringBuilder name = new StringBuilder();
        name.append(context.getApplicationName() + "_");
        name.append(context.getModuleName() + "_");
        if (context.getComponentName() != null) {
            name.append(context.getComponentName() + "_");
        }
        name.append(jndiName);
        return name.toString();
    }

    private void startDataSource(AbstractDataSourceService dataSourceService, final String jndiName, EEModuleDescription moduleDescription, InjectionSource.ResolutionContext context, ServiceTarget serviceTarget, ServiceBuilder valueSourceServiceBuilder, Injector<ManagedReferenceFactory> injector) {
        ServiceName dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{"DataSourceDefinition", moduleDescription.getApplicationName(), moduleDescription.getModuleName(), jndiName});
        ServiceBuilder dataSourceServiceBuilder = Services.addServerExecutorDependency((ServiceBuilder)serviceTarget.addService(dataSourceServiceName, (Service)dataSourceService), dataSourceService.getExecutorServiceInjector(), (boolean)false).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, dataSourceService.getTransactionIntegrationInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, dataSourceService.getManagementRepositoryInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, dataSourceService.getSubjectFactoryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, dataSourceService.getCcmInjector()).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, dataSourceService.getDriverRegistryInjector()).addDependency(NamingService.SERVICE_NAME);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)context.getApplicationName(), (String)context.getModuleName(), (String)context.getComponentName(), (!context.isCompUsesModule() ? 1 : 0) != 0, (String)jndiName);
        DataSourceReferenceFactoryService referenceFactoryService = new DataSourceReferenceFactoryService();
        ServiceName referenceFactoryServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(bindInfo.getBinderServiceName());
        ServiceBuilder referenceBuilder = serviceTarget.addService(referenceFactoryServiceName, (Service)referenceFactoryService).addDependency(dataSourceServiceName, DataSource.class, referenceFactoryService.getDataSourceInjector());
        BinderService binderService = new BinderService(bindInfo.getBindName(), (Object)this);
        ServiceBuilder binderBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, binderService.getManagedObjectInjector()).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.boundDataSource(jndiName);
                        break;
                    }
                    case START_REQUESTED_to_DOWN: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.unboundDataSource(jndiName);
                        break;
                    }
                    case REMOVING_to_REMOVED: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.debugf("Removed JDBC Data-source [%s]", jndiName);
                    }
                }
            }
        });
        dataSourceServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        valueSourceServiceBuilder.addDependency(bindInfo.getBinderServiceName(), ManagedReferenceFactory.class, injector);
    }

    private TransactionIsolation transactionIsolation() {
        switch (this.isolationLevel) {
            case 0: {
                return TransactionIsolation.TRANSACTION_NONE;
            }
            case 2: {
                return TransactionIsolation.TRANSACTION_READ_COMMITTED;
            }
            case 1: {
                return TransactionIsolation.TRANSACTION_READ_UNCOMMITTED;
            }
            case 4: {
                return TransactionIsolation.TRANSACTION_REPEATABLE_READ;
            }
            case 8: {
                return TransactionIsolation.TRANSACTION_SERIALIZABLE;
            }
        }
        return TransactionIsolation.TRANSACTION_READ_COMMITTED;
    }

    private void populateProperties(DeploymentReflectionIndex deploymentReflectionIndex, Class<?> dataSourceClass, Map<String, String> properties) {
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, DESCRIPTION_PROP, this.description);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, URL_PROP, this.url);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, UPPERCASE_URL_PROP, this.url);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, DATABASE_NAME_PROP, this.databaseName);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, SERVER_NAME_PROP, this.serverName);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, PORT_NUMBER_PROP, this.portNumber);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, LOGIN_TIMEOUT_PROP, this.loginTimeout);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, ISOLATION_LEVEL_PROP, this.isolationLevel);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, TRANSACTIONAL_PROP, this.transactional);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, INITIAL_POOL_SIZE_PROP, this.initialPoolSize);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, MAX_IDLE_TIME_PROP, this.maxIdleTime);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, MAX_POOL_SIZE_PROP, this.maxPoolSize);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, MAX_STATEMENTS_PROP, this.maxStatements);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, MIN_POOL_SIZE_PROP, this.minPoolSize);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, USER_PROP, this.user);
        this.setProperty(deploymentReflectionIndex, dataSourceClass, properties, PASSWORD_PROP, this.password);
    }

    private void setProperty(DeploymentReflectionIndex deploymentReflectionIndex, Class<?> dataSourceClass, Map<String, String> properties, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String && "".equals(value)) {
            return;
        }
        if (value instanceof Integer && (Integer)value == -1) {
            return;
        }
        StringBuilder builder = new StringBuilder("set").append(name);
        builder.setCharAt(3, Character.toUpperCase(name.charAt(0)));
        String methodName = builder.toString();
        Class<?> paramType = value.getClass();
        MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[]{paramType});
        Method setterMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)deploymentReflectionIndex, dataSourceClass, (MethodIdentifier)methodIdentifier);
        if (setterMethod != null) {
            properties.put(name, value.toString());
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public void setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public void setProperties(String[] properties) {
        this.properties = properties;
    }
}

