/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.jbossts;

import javax.resource.ResourceException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.jca.core.spi.transaction.ConnectableResource;
import org.jboss.jca.core.spi.transaction.ConnectableResourceListener;
import org.jboss.jca.core.spi.transaction.local.LocalResourceException;
import org.jboss.jca.core.spi.transaction.local.LocalXAException;
import org.jboss.jca.core.tx.jbossts.LocalXAResourceImpl;

public class LocalConnectableXAResourceImpl
extends LocalXAResourceImpl
implements ConnectableResource,
org.jboss.tm.ConnectableResource {
    private ConnectableResource cr;
    private ConnectableResourceListener crl;

    public LocalConnectableXAResourceImpl(String productName, String productVersion, String jndiName, ConnectableResource cr) {
        super(productName, productVersion, jndiName);
        this.cr = cr;
        this.crl = null;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (!xid.equals(this.currentXid)) {
            throw new LocalXAException(bundle.wrongXidInCommit(this.currentXid, xid), -6);
        }
        this.currentXid = null;
        try {
            this.cl.getManagedConnection().getLocalTransaction().commit();
        }
        catch (LocalResourceException lre) {
            this.connectionManager.returnManagedConnection(this.cl, true);
            throw new LocalXAException(bundle.couldNotCommitLocalTx(), -7, (Throwable)lre);
        }
        catch (ResourceException re) {
            this.connectionManager.returnManagedConnection(this.cl, true);
            throw new LocalXAException(bundle.couldNotCommitLocalTx(), 100, (Throwable)re);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (!xid.equals(this.currentXid)) {
            throw new LocalXAException(bundle.wrongXidInRollback(this.currentXid, xid), -6);
        }
        this.currentXid = null;
        try {
            this.cl.getManagedConnection().getLocalTransaction().rollback();
        }
        catch (LocalResourceException lre) {
            this.connectionManager.returnManagedConnection(this.cl, true);
            throw new LocalXAException(bundle.couldNotRollbackLocalTx(), -7, (Throwable)lre);
        }
        catch (ResourceException re) {
            this.connectionManager.returnManagedConnection(this.cl, true);
            throw new LocalXAException(bundle.couldNotRollbackLocalTx(), -3, (Throwable)re);
        }
    }

    public Object getConnection() throws Exception {
        Object result = this.cr.getConnection();
        if (this.crl != null) {
            this.crl.handleCreated(result);
        }
        return result;
    }

    public void setConnectableResourceListener(ConnectableResourceListener crl) {
        this.crl = crl;
    }
}

