/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListenerFactory;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PrefillPool;
import org.jboss.jca.core.connectionmanager.pool.idle.IdleRemover;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatistics;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatisticsImpl;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolUtility;
import org.jboss.jca.core.connectionmanager.pool.mcp.PoolFiller;
import org.jboss.jca.core.connectionmanager.pool.mcp.Semaphore;
import org.jboss.jca.core.connectionmanager.pool.validator.ConnectionValidator;
import org.jboss.logging.Messages;

public class SemaphoreConcurrentLinkedQueueManagedConnectionPool
implements ManagedConnectionPool {
    private CoreLogger log;
    private boolean debug;
    private boolean trace;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private ManagedConnectionFactory mcf;
    private ConnectionListenerFactory clf;
    private Subject defaultSubject;
    private ConnectionRequestInfo defaultCri;
    private PoolConfiguration poolConfiguration;
    private Pool pool;
    private int maxSize;
    private ConcurrentLinkedQueue<ConnectionListenerWrapper> clq;
    private Map<ConnectionListener, ConnectionListenerWrapper> cls;
    private AtomicInteger poolSize = new AtomicInteger();
    private AtomicInteger checkedOutSize = new AtomicInteger();
    private Semaphore permits;
    private ManagedConnectionPoolStatisticsImpl statistics;

    @Override
    public void initialize(ManagedConnectionFactory mcf, ConnectionListenerFactory clf, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p) {
        if (mcf == null) {
            throw new IllegalArgumentException("ManagedConnectionFactory is null");
        }
        if (clf == null) {
            throw new IllegalArgumentException("ConnectionListenerFactory is null");
        }
        if (pc == null) {
            throw new IllegalArgumentException("PoolConfiguration is null");
        }
        if (p == null) {
            throw new IllegalArgumentException("Pool is null");
        }
        this.mcf = mcf;
        this.clf = clf;
        this.defaultSubject = subject;
        this.defaultCri = cri;
        this.poolConfiguration = pc;
        this.maxSize = pc.getMaxSize();
        this.pool = p;
        this.log = this.pool.getLogger();
        this.debug = this.log.isDebugEnabled();
        this.trace = this.log.isTraceEnabled();
        this.clq = new ConcurrentLinkedQueue();
        this.cls = new ConcurrentHashMap<ConnectionListener, ConnectionListenerWrapper>();
        this.statistics = new ManagedConnectionPoolStatisticsImpl(this.maxSize);
        this.statistics.setEnabled(p.getStatistics().isEnabled());
        this.permits = new Semaphore(this.maxSize, true, this.statistics);
        this.poolSize.set(0);
        this.checkedOutSize.set(0);
        if ((pc.isPrefill() || pc.isStrictMin()) && p instanceof PrefillPool && pc.getMinSize() > 0) {
            PoolFiller.fillPool(this);
        }
        this.reenable();
    }

    @Override
    public boolean isRunning() {
        return !this.pool.isShutdown();
    }

    @Override
    public boolean isEmpty() {
        return this.poolSize.get() == 0;
    }

    @Override
    public boolean isFull() {
        return this.checkedOutSize.get() == this.maxSize;
    }

    @Override
    public boolean isIdle() {
        return this.checkedOutSize.get() == 0;
    }

    @Override
    public int getActive() {
        return this.poolSize.get();
    }

    private boolean isSize(int size) {
        return this.poolSize.get() >= size;
    }

    @Override
    public void reenable() {
        if (this.poolConfiguration.getIdleTimeoutMinutes() > 0) {
            IdleRemover.getInstance().registerPool(this, (long)this.poolConfiguration.getIdleTimeoutMinutes() * 1000L * 60L);
        }
        if (this.poolConfiguration.isBackgroundValidation() && this.poolConfiguration.getBackgroundValidationMillis() > 0L) {
            if (this.debug) {
                this.log.debug("Registering for background validation at interval " + this.poolConfiguration.getBackgroundValidationMillis());
            }
            ConnectionValidator.getInstance().registerPool(this, this.poolConfiguration.getBackgroundValidationMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionListener getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (this.trace) {
            Map<ConnectionListener, ConnectionListenerWrapper> map = this.cls;
            synchronized (map) {
                String method = "getConnection(" + subject + ", " + cri + ")";
                TreeSet<ConnectionListener> checkedOut = new TreeSet<ConnectionListener>();
                TreeSet<ConnectionListener> available = new TreeSet<ConnectionListener>();
                for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                    if (entry.getValue().isCheckedOut()) {
                        checkedOut.add(entry.getKey());
                        continue;
                    }
                    available.add(entry.getKey());
                }
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(System.identityHashCode(this), method, this.mcf, this.clf, this.pool, this.poolConfiguration, available, checkedOut, this.statistics));
            }
        } else if (this.debug) {
            String method = "getConnection(" + subject + ", " + cri + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.statistics.getInUseCount(), this.maxSize));
        }
        subject = subject == null ? this.defaultSubject : subject;
        cri = cri == null ? this.defaultCri : cri;
        long startWait = this.statistics.isEnabled() ? System.currentTimeMillis() : 0L;
        try {
            if (this.permits.tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) {
                if (this.statistics.isEnabled()) {
                    this.statistics.deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                }
                ConnectionListenerWrapper clw = null;
                do {
                    if (!this.isRunning()) {
                        this.permits.release();
                        throw new ResourceException(bundle.thePoolHasBeenShutdown(this.pool.getName(), Integer.toHexString(System.identityHashCode(this))));
                    }
                    clw = this.clq.poll();
                    if (clw == null) continue;
                    clw.setCheckedOut(true);
                    this.checkedOutSize.incrementAndGet();
                    try {
                        ManagedConnection matchedMC = this.mcf.matchManagedConnections(Collections.singleton(clw.getConnectionListener().getManagedConnection()), subject, cri);
                        if (matchedMC != null) {
                            if (this.trace) {
                                this.log.trace("supplying ManagedConnection from pool: " + clw.getConnectionListener());
                            }
                            clw.setHasPermit(true);
                            return clw.getConnectionListener();
                        }
                        this.log.destroyingConnectionNotSuccessfullyMatched(clw.getConnectionListener());
                        this.doDestroy(clw);
                        clw = null;
                    }
                    catch (Throwable t) {
                        this.log.throwableWhileTryingMatchManagedConnectionThenDestroyingConnection(clw.getConnectionListener(), t);
                        if (clw.isCheckedOut()) {
                            clw.setCheckedOut(false);
                            this.checkedOutSize.decrementAndGet();
                        }
                        if (this.statistics.isEnabled()) {
                            this.statistics.setInUsedCount(this.checkedOutSize.get());
                        }
                        this.doDestroy(clw);
                        clw = null;
                    }
                    if (!this.poolConfiguration.isUseFastFail()) continue;
                    if (!this.trace) break;
                    this.log.trace("Fast failing for connection attempt. No more attempts will be made to acquire connection from pool and a new connection will be created immeadiately");
                    break;
                } while (this.clq.size() > 0);
                try {
                    clw = new ConnectionListenerWrapper(this.createConnectionEventListener(subject, cri), true, true);
                    clw.setCheckedOut(true);
                    this.checkedOutSize.incrementAndGet();
                    this.cls.put(clw.getConnectionListener(), clw);
                    this.poolSize.incrementAndGet();
                    if (this.statistics.isEnabled()) {
                        this.statistics.setInUsedCount(this.checkedOutSize.get());
                    }
                    if (this.trace) {
                        this.log.trace("supplying new ManagedConnection: " + clw.getConnectionListener());
                    }
                    if ((this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool && this.poolConfiguration.getMinSize() > 0) {
                        PoolFiller.fillPool(this);
                    }
                    return clw.getConnectionListener();
                }
                catch (Throwable t) {
                    this.log.throwableWhileAttemptingGetNewGonnection(clw.getConnectionListener(), t);
                    if (clw != null) {
                        this.doDestroy(clw);
                    }
                    if (this.statistics.isEnabled()) {
                        this.statistics.setInUsedCount(this.checkedOutSize.get());
                    }
                    this.permits.release();
                    throw new ResourceException(bundle.unexpectedThrowableWhileTryingCreateConnection(clw != null ? clw.getConnectionListener() : null), t);
                }
            }
            throw new ResourceException(bundle.noMManagedConnectionsAvailableWithinConfiguredBlockingTimeout(this.poolConfiguration.getBlockingTimeout()));
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            long end = this.statistics.isEnabled() ? System.currentTimeMillis() - startWait : 0L;
            this.statistics.deltaTotalBlockingTime(end);
            throw new ResourceException(bundle.interruptedWhileRequestingPermit(end));
        }
        catch (Exception e) {
            this.permits.release();
            throw new ResourceException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnConnection(ConnectionListener cl, boolean kill) {
        if (this.trace) {
            Map<ConnectionListener, ConnectionListenerWrapper> map = this.cls;
            synchronized (map) {
                String method = "returnConnection(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")";
                TreeSet<ConnectionListener> checkedOut = new TreeSet<ConnectionListener>();
                TreeSet<ConnectionListener> available = new TreeSet<ConnectionListener>();
                for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                    if (entry.getValue().isCheckedOut()) {
                        checkedOut.add(entry.getKey());
                        continue;
                    }
                    available.add(entry.getKey());
                }
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(System.identityHashCode(this), method, this.mcf, this.clf, this.pool, this.poolConfiguration, available, checkedOut, this.statistics));
            }
        } else if (this.debug) {
            String method = "returnConnection(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.statistics.getInUseCount(), this.maxSize));
        }
        ConnectionListenerWrapper clw = this.cls.get(cl);
        if (cl.getState() == ConnectionState.DESTROYED) {
            if (this.trace) {
                this.log.trace("ManagedConnection is being returned after it was destroyed: " + cl);
            }
            if (clw != null && clw.hasPermit()) {
                clw.setHasPermit(false);
                this.permits.release();
            }
            return;
        }
        try {
            cl.getManagedConnection().cleanup();
        }
        catch (ResourceException re) {
            this.log.resourceExceptionCleaningUpManagedConnection(cl, re);
            kill = true;
        }
        if (clw == null || cl.getState() == ConnectionState.DESTROY || cl.getState() == ConnectionState.DESTROYED) {
            kill = true;
        }
        if (!kill && this.isSize(this.poolConfiguration.getMaxSize() + 1)) {
            this.log.destroyingReturnedConnectionMaximumPoolSizeExceeded(cl);
            kill = true;
        }
        boolean releasePermit = false;
        if (clw != null) {
            if (clw.hasPermit()) {
                clw.setHasPermit(false);
                releasePermit = true;
            }
            if (clw.isCheckedOut()) {
                clw.setCheckedOut(false);
                this.checkedOutSize.decrementAndGet();
            }
        }
        if (kill) {
            this.cls.remove(cl);
        } else {
            cl.used();
            if (!this.clq.contains(clw)) {
                this.clq.add(clw);
            } else {
                this.log.attemptReturnConnectionTwice(cl, new Throwable("STACKTRACE"));
            }
        }
        if (this.statistics.isEnabled()) {
            this.statistics.setInUsedCount(this.checkedOutSize.get());
        }
        if (kill) {
            if (this.trace) {
                this.log.trace("Destroying returned connection " + cl);
            }
            this.doDestroy(clw);
            clw = null;
        }
        if (releasePermit) {
            this.permits.release();
        }
    }

    @Override
    public void flush() {
        this.flush(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(boolean kill) {
        ArrayList<ConnectionListenerWrapper> destroy = null;
        Map<ConnectionListener, ConnectionListenerWrapper> map = this.cls;
        synchronized (map) {
            if (kill) {
                if (this.trace) {
                    TreeSet<ConnectionListener> checkedOut = new TreeSet<ConnectionListener>();
                    for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                        if (!entry.getValue().isCheckedOut()) continue;
                        checkedOut.add(entry.getKey());
                    }
                    this.log.trace("Flushing pool checkedOut=" + checkedOut + " inPool=" + this.cls);
                }
                for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                    if (!entry.getValue().isCheckedOut()) continue;
                    if (this.trace) {
                        this.log.trace("Flush marking checked out connection for destruction " + entry.getKey());
                    }
                    entry.getValue().setCheckedOut(false);
                    this.checkedOutSize.decrementAndGet();
                    if (entry.getValue().hasPermit()) {
                        entry.getValue().setHasPermit(false);
                        this.permits.release();
                    }
                    entry.getKey().setState(ConnectionState.DESTROY);
                    if (destroy == null) {
                        destroy = new ArrayList(1);
                    }
                    destroy.add(entry.getValue());
                    this.clq.remove(entry.getValue());
                    this.cls.remove(entry.getKey());
                    this.poolSize.decrementAndGet();
                }
                if (this.statistics.isEnabled()) {
                    this.statistics.setInUsedCount(this.checkedOutSize.get());
                }
            }
            for (ConnectionListenerWrapper clw : this.clq) {
                this.clq.remove(clw);
                this.cls.remove(clw.getConnectionListener());
                this.poolSize.decrementAndGet();
                if (destroy == null) {
                    destroy = new ArrayList<ConnectionListenerWrapper>(1);
                }
                clw.getConnectionListener().setState(ConnectionState.DESTROY);
                destroy.add(clw);
            }
        }
        if (destroy != null) {
            for (ConnectionListenerWrapper clw : destroy) {
                if (this.trace) {
                    this.log.trace("Destroying flushed connection " + clw.getConnectionListener());
                }
                this.doDestroy(clw);
                clw = null;
            }
        }
        if (this.isRunning() && this.poolConfiguration.getMinSize() > 0 && (this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool) {
            PoolFiller.fillPool(this);
        }
    }

    @Override
    public void removeIdleConnections() {
        long now = System.currentTimeMillis();
        long timeoutSetting = (long)this.poolConfiguration.getIdleTimeoutMinutes() * 1000L * 60L;
        ArrayList<ConnectionListenerWrapper> destroyConnections = null;
        long timeout = now - timeoutSetting;
        Iterator<ConnectionListenerWrapper> clwIter = this.clq.iterator();
        while (clwIter.hasNext() && this.clq.size() != 0) {
            ConnectionListenerWrapper clw = clwIter.next();
            if (!clw.getConnectionListener().isTimedOut(timeout) || !this.shouldRemove()) continue;
            if (this.statistics.isEnabled()) {
                this.statistics.deltaTimedOut();
            }
            if (this.cls.remove(clw.getConnectionListener()) != null) {
                this.poolSize.decrementAndGet();
            }
            if (destroyConnections == null) {
                destroyConnections = new ArrayList<ConnectionListenerWrapper>(1);
            }
            destroyConnections.add(clw);
        }
        if (destroyConnections != null) {
            for (ConnectionListenerWrapper clw : destroyConnections) {
                if (this.trace) {
                    this.log.trace("Destroying connection " + clw.getConnectionListener());
                }
                this.doDestroy(clw);
                clw = null;
            }
            if (this.isRunning()) {
                boolean emptyManagedConnectionPool = false;
                if ((this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool) {
                    if (this.poolConfiguration.getMinSize() > 0) {
                        PoolFiller.fillPool(this);
                    } else {
                        emptyManagedConnectionPool = true;
                    }
                } else {
                    emptyManagedConnectionPool = true;
                }
                if (emptyManagedConnectionPool && this.isEmpty()) {
                    this.pool.emptyManagedConnectionPool(this);
                }
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.trace) {
            this.log.tracef("Shutdown - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
        }
        IdleRemover.getInstance().unregisterPool(this);
        ConnectionValidator.getInstance().unregisterPool(this);
        if (this.checkedOutSize.get() > 0) {
            for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                if (!entry.getValue().isCheckedOut()) continue;
                this.log.destroyingActiveConnection(this.pool.getName(), entry.getKey().getManagedConnection());
            }
        }
        this.flush(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillToMin() {
        if (this.poolConfiguration.getMinSize() <= 0) {
            return;
        }
        if (!this.poolConfiguration.isPrefill() && !this.poolConfiguration.isStrictMin()) {
            return;
        }
        if (!(this.pool instanceof PrefillPool)) {
            return;
        }
        while (true) {
            try {
                while (true) {
                    long startWait;
                    long l = startWait = this.statistics.isEnabled() ? System.currentTimeMillis() : 0L;
                    if (!this.permits.tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) continue;
                    if (this.statistics.isEnabled()) {
                        this.statistics.deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                    }
                    try {
                        if (!this.isRunning()) {
                            if (this.statistics.isEnabled()) {
                                this.statistics.setInUsedCount(this.checkedOutSize.get());
                            }
                            return;
                        }
                        if (this.isSize(this.poolConfiguration.getMinSize())) {
                            if (this.statistics.isEnabled()) {
                                this.statistics.setInUsedCount(this.checkedOutSize.get());
                            }
                            return;
                        }
                        try {
                            ConnectionListener cl = this.createConnectionEventListener(this.defaultSubject, this.defaultCri);
                            if (this.trace) {
                                this.log.trace("Filling pool cl=" + cl);
                            }
                            this.cls.put(cl, new ConnectionListenerWrapper(cl, false, false));
                            this.poolSize.incrementAndGet();
                            this.clq.add(this.cls.get(cl));
                            if (!this.statistics.isEnabled()) continue;
                            this.statistics.setInUsedCount(this.checkedOutSize.get() + 1);
                            continue;
                        }
                        catch (ResourceException re) {
                            if (this.statistics.isEnabled()) {
                                this.statistics.setInUsedCount(this.checkedOutSize.get());
                            }
                            this.log.unableFillPool(re);
                            this.permits.release();
                            return;
                        }
                    }
                    finally {
                        this.permits.release();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ignored) {
                Thread.interrupted();
                if (!this.trace) continue;
                this.log.trace("Interrupted while requesting permit in fillToMin");
                continue;
            }
            break;
        }
    }

    @Override
    public ManagedConnectionPoolStatistics getStatistics() {
        return this.statistics;
    }

    private ConnectionListener createConnectionEventListener(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        long start = this.statistics.isEnabled() ? System.currentTimeMillis() : 0L;
        ManagedConnection mc = this.mcf.createManagedConnection(subject, cri);
        if (this.statistics.isEnabled()) {
            this.statistics.deltaTotalCreationTime(System.currentTimeMillis() - start);
            this.statistics.deltaCreatedCount();
        }
        try {
            return this.clf.createConnectionListener(mc, this);
        }
        catch (ResourceException re) {
            if (this.statistics.isEnabled()) {
                this.statistics.deltaDestroyedCount();
            }
            mc.destroy();
            throw re;
        }
    }

    private void doDestroy(ConnectionListenerWrapper clw) {
        if (clw != null) {
            this.removeConnectionListenerFromPool(clw);
            if (clw.getConnectionListener() != null) {
                if (clw.getConnectionListener().getState() == ConnectionState.DESTROYED) {
                    if (this.trace) {
                        this.log.trace("ManagedConnection is already destroyed " + clw.getConnectionListener());
                    }
                    return;
                }
                if (this.statistics.isEnabled()) {
                    this.statistics.deltaDestroyedCount();
                }
                clw.getConnectionListener().setState(ConnectionState.DESTROYED);
                ManagedConnection mc = clw.getConnectionListener().getManagedConnection();
                try {
                    mc.destroy();
                }
                catch (Throwable t) {
                    this.log.debug("Exception destroying ManagedConnection " + clw.getConnectionListener(), t);
                }
                mc.removeConnectionEventListener((ConnectionEventListener)clw.getConnectionListener());
                clw.setConnectionListener(null);
            }
        }
    }

    private boolean shouldRemove() {
        boolean remove = true;
        if (this.poolConfiguration.isStrictMin() && this.pool instanceof PrefillPool) {
            remove = this.isSize(this.poolConfiguration.getMinSize() + 1);
            if (this.trace) {
                this.log.trace("StrictMin is active. Current connection will be removed is " + remove);
            }
        }
        return remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void validateConnections() throws Exception {
        block30: {
            if (this.trace) {
                this.log.trace("Attempting to  validate connections for pool " + this);
            }
            if (!this.permits.tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) break block30;
            anyDestroyed = false;
            block20: while (true) {
                while (true) lbl-1000:
                // 3 sources

                {
                    cl = null;
                    destroyed = false;
                    var4_4 = this.cls;
                    synchronized (var4_4) {
                        if (this.clq.size() == 0) {
                            break block30;
                        }
                        cl = this.removeForFrequencyCheck();
                    }
                    if (cl == null) {
                        break block30;
                    }
                    try {
                        candidateSet = Collections.singleton(cl.getManagedConnection());
                        if (this.mcf instanceof ValidatingManagedConnectionFactory) {
                            vcf = (ValidatingManagedConnectionFactory)this.mcf;
                            if ((candidateSet = vcf.getInvalidConnections(candidateSet)) != null && candidateSet.size() > 0 && cl.getState() != ConnectionState.DESTROY) {
                                clw = this.cls.remove(cl);
                                this.doDestroy(clw);
                                clw = null;
                                destroyed = true;
                                anyDestroyed = true;
                            }
                        } else {
                            this.log.backgroundValidationNonCompliantManagedConnectionFactory();
                        }
                        if (destroyed) ** GOTO lbl-1000
                        candidateSet = this.cls;
                    }
                    catch (ResourceException re) {
                        if (cl != null) {
                            clw = this.cls.remove(cl);
                            this.doDestroy(clw);
                            clw = null;
                            destroyed = true;
                            anyDestroyed = true;
                        }
                        this.log.connectionValidatorIgnoredUnexpectedError(re);
                        continue block20;
                    }
                    finally {
                        if (destroyed) continue;
                        var4_4 = this.cls;
                        synchronized (var4_4) {
                            this.returnForFrequencyCheck(cl);
                        }
                        continue block20;
                    }
                    synchronized (candidateSet) {
                        this.returnForFrequencyCheck(cl);
                        continue block20;
                    }
                    break;
                }
                break;
            }
            finally {
                this.permits.release();
                if (anyDestroyed && this.isRunning() && this.poolConfiguration.getMinSize() > 0 && (this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool) {
                    PoolFiller.fillPool(this);
                }
            }
        }
    }

    private ConnectionListener removeForFrequencyCheck() {
        this.log.debug("Checking for connection within frequency");
        ConnectionListenerWrapper clw2 = null;
        for (ConnectionListenerWrapper clw2 : this.clq) {
            long lastCheck = clw2.getConnectionListener().getLastValidatedTime();
            if (System.currentTimeMillis() - lastCheck >= this.poolConfiguration.getBackgroundValidationMillis()) {
                this.clq.remove(clw2);
                break;
            }
            clw2 = null;
        }
        if (clw2 != null) {
            return clw2.getConnectionListener();
        }
        return null;
    }

    private void returnForFrequencyCheck(ConnectionListener cl) {
        this.log.debug("Returning for connection within frequency");
        cl.setLastValidatedTime(System.currentTimeMillis());
        this.clq.add(this.cls.get(cl));
    }

    private void removeConnectionListenerFromPool(ConnectionListenerWrapper clw) {
        if (clw != null) {
            this.clq.remove(clw);
            if (clw.getConnectionListener() != null && this.cls.remove(clw.getConnectionListener()) != null) {
                this.poolSize.decrementAndGet();
            }
            if (clw.isCheckedOut()) {
                clw.setCheckedOut(false);
                this.checkedOutSize.decrementAndGet();
                if (this.statistics.isEnabled()) {
                    this.statistics.setInUsedCount(this.checkedOutSize.get());
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SemaphoreConcurrentLinkedQueueManagedConnectionPool@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[pool=").append(this.pool.getName());
        sb.append("]");
        return sb.toString();
    }

    static class ConnectionListenerWrapper {
        private volatile ConnectionListener connectionListener;
        private volatile boolean checkedOut;
        private volatile boolean hasPermit;

        public ConnectionListenerWrapper(ConnectionListener connectionListener) {
            this(connectionListener, false, false);
        }

        public ConnectionListenerWrapper(ConnectionListener connectionListener, boolean checkedOut) {
            this(connectionListener, checkedOut, false);
        }

        public ConnectionListenerWrapper(ConnectionListener connectionListener, boolean checkedOut, boolean hasPermit) {
            this.connectionListener = connectionListener;
            this.checkedOut = checkedOut;
            this.hasPermit = hasPermit;
        }

        public ConnectionListener getConnectionListener() {
            return this.connectionListener;
        }

        public void setConnectionListener(ConnectionListener connectionListener) {
            this.connectionListener = connectionListener;
        }

        public boolean isCheckedOut() {
            return this.checkedOut;
        }

        public void setCheckedOut(boolean checkedOut) {
            this.checkedOut = checkedOut;
        }

        public boolean hasPermit() {
            return this.hasPermit;
        }

        public void setHasPermit(boolean hasPermit) {
            this.hasPermit = hasPermit;
        }
    }
}

