/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

class CaseInsensitiveDictionary
extends Dictionary {
    private Hashtable internalMap;
    private Hashtable originalKeys;

    CaseInsensitiveDictionary() {
        this.internalMap = new Hashtable();
        this.originalKeys = new Hashtable();
    }

    CaseInsensitiveDictionary(Dictionary props) {
        this();
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            CaseInsensitiveDictionary.checkKey(key);
            String lowerCase = ((String)key).toLowerCase();
            if (this.internalMap.containsKey(lowerCase)) {
                throw new IllegalArgumentException("Key [" + key + "] already present in different case");
            }
            Object value = props.get(key);
            value = CaseInsensitiveDictionary.checkValue(value);
            this.internalMap.put(lowerCase, value);
            this.originalKeys.put(lowerCase, key);
        }
    }

    CaseInsensitiveDictionary(CaseInsensitiveDictionary props, boolean deepCopy) {
        Hashtable tmp = new Hashtable(Math.max(2 * props.internalMap.size(), 11), 0.75f);
        if (deepCopy) {
            for (Map.Entry entry : props.internalMap.entrySet()) {
                Object value = entry.getValue();
                if (value.getClass().isArray()) {
                    int length = Array.getLength(value);
                    Object newValue = Array.newInstance(value.getClass().getComponentType(), length);
                    System.arraycopy(value, 0, newValue, 0, length);
                    value = newValue;
                } else if (value instanceof Collection) {
                    value = new Vector((Collection)value);
                }
                tmp.put(entry.getKey(), value);
            }
        } else {
            tmp.putAll(props.internalMap);
        }
        this.internalMap = tmp;
        this.originalKeys = new Hashtable(props.originalKeys);
    }

    public Enumeration elements() {
        return Collections.enumeration(this.internalMap.values());
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String stringKey = String.valueOf(key).toLowerCase();
        return this.internalMap.get(stringKey);
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    public Enumeration keys() {
        return Collections.enumeration(this.originalKeys.values());
    }

    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException("key or value");
        }
        CaseInsensitiveDictionary.checkKey(key);
        value = CaseInsensitiveDictionary.checkValue(value);
        String lowerCase = String.valueOf(key).toLowerCase();
        this.originalKeys.put(lowerCase, key);
        return this.internalMap.put(lowerCase, value);
    }

    public Object remove(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String lowerCase = String.valueOf(key).toLowerCase();
        this.originalKeys.remove(lowerCase);
        return this.internalMap.remove(lowerCase);
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    static void checkKey(Object keyObject) {
        if (!(keyObject instanceof String)) {
            throw new IllegalArgumentException("Key [" + keyObject + "] must be a String");
        }
        String key = (String)keyObject;
        if (key.length() == 0) {
            throw new IllegalArgumentException("Key [" + key + "] must not be an empty string");
        }
    }

    static Object checkValue(Object value) {
        Class<?> type;
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        if (value.getClass().isArray()) {
            type = value.getClass().getComponentType();
            if (type.isPrimitive()) {
                return value;
            }
        } else if (value instanceof Collection) {
            Collection collection = value;
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("Collection must not be empty");
            }
            ArrayList internalValue = new ArrayList(collection.size());
            type = null;
            for (Object el : collection) {
                if (el == null) {
                    throw new IllegalArgumentException("Collection must not contain null elements");
                }
                if (type == null) {
                    type = el.getClass();
                } else if (type != el.getClass()) {
                    throw new IllegalArgumentException("Collection element types must not be mixed");
                }
                internalValue.add(el);
            }
            value = internalValue;
        } else {
            type = value.getClass();
        }
        if (type == String.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == Byte.class || type == Short.class || type == Character.class || type == Boolean.class) {
            return value;
        }
        throw new IllegalArgumentException("Value [" + value + "] has unsupported (base-) type " + type);
    }

    public String toString() {
        return this.internalMap.toString();
    }
}

