/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldCacheDocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;

public class FieldCacheTermsFilter
extends Filter {
    private String field;
    private String[] terms;

    public FieldCacheTermsFilter(String field, String ... terms) {
        this.field = field;
        this.terms = terms;
    }

    public FieldCache getFieldCache() {
        return FieldCache.DEFAULT;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        final FieldCache.StringIndex fcsi = this.getFieldCache().getStringIndex(reader, this.field);
        final FixedBitSet bits = new FixedBitSet(fcsi.lookup.length);
        for (int i = 0; i < this.terms.length; ++i) {
            int termNumber = fcsi.binarySearchLookup(this.terms[i]);
            if (termNumber <= 0) continue;
            bits.set(termNumber);
        }
        return new FieldCacheDocIdSet(reader){

            @Override
            protected final boolean matchDoc(int doc) {
                return bits.get(fcsi.order[doc]);
            }
        };
    }
}

