/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.threads.BoundedQueueThreadPoolResourceDefinition;
import org.jboss.as.threads.Namespace;
import org.jboss.as.threads.QueuelessThreadPoolResourceDefinition;
import org.jboss.as.threads.ScheduledThreadPoolResourceDefinition;
import org.jboss.as.threads.ThreadFactoryResourceDefinition;
import org.jboss.as.threads.ThreadSubsystemResourceDefinition;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.as.threads.ThreadsParser;
import org.jboss.as.threads.UnboundedQueueThreadPoolResourceDefinition;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class ThreadsExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "threads";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"threads");
    static final String RESOURCE_NAME = ThreadsExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 1;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    static final ModelVersion DEPRECATED_SINCE = ModelVersion.create((int)1, (int)1, (int)0);

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix, boolean useUnprefixedChildTypes) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, ThreadsExtension.class.getClassLoader(), true, useUnprefixedChildTypes);
    }

    public void initialize(ExtensionContext context) {
        ThreadsLogger.ROOT_LOGGER.debugf("Initializing Threading Extension", new Object[0]);
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, 1, 1, 0);
        registration.registerXMLElementWriter((XMLElementWriter)ThreadsParser.INSTANCE);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel((ResourceDefinition)new ThreadSubsystemResourceDefinition(registerRuntimeOnly));
        subsystem.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        if (context.isRegisterTransformers()) {
            ThreadsExtension.registerTransformers1_0(registration);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.CURRENT.getUriString(), (XMLElementReader)ThreadsParser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.THREADS_1_0.getUriString(), (XMLElementReader)ThreadsParser.INSTANCE);
    }

    private static void registerTransformers1_0(SubsystemRegistration subsystem) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        BoundedQueueThreadPoolResourceDefinition.registerTransformers1_0(builder);
        QueuelessThreadPoolResourceDefinition.registerTransformers1_0(builder);
        ScheduledThreadPoolResourceDefinition.registerTransformers1_0(builder);
        UnboundedQueueThreadPoolResourceDefinition.registerTransformers1_0(builder);
        ThreadFactoryResourceDefinition.registerTransformers1_0(builder);
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystem, (ModelVersionRange)ModelVersion.create((int)1, (int)0, (int)0));
    }
}

