/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.net.InetSocketAddress;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.modcluster.ModCluster;
import org.jboss.as.modcluster.ModClusterExtension;
import org.jboss.as.modcluster.ModClusterLogger;
import org.jboss.as.modcluster.ModClusterService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class ModClusterListProxies
implements OperationStepHandler {
    static final ModClusterListProxies INSTANCE = new ModClusterListProxies();

    static OperationDefinition getDefinition(ResourceDescriptionResolver descriptionResolver) {
        return new SimpleOperationDefinitionBuilder("list-proxies", descriptionResolver).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF).build();
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer() && context.getServiceRegistry(false).getService(ModClusterService.NAME) != null) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry(false).getService(ModClusterService.NAME);
                    ModCluster modcluster = (ModCluster)controller.getValue();
                    Map<InetSocketAddress, String> map = modcluster.getProxyInfo();
                    ModClusterLogger.ROOT_LOGGER.debugf("Mod_cluster ListProxies %s", map);
                    if (!map.isEmpty()) {
                        InetSocketAddress[] addr;
                        ModelNode result = new ModelNode();
                        for (InetSocketAddress address : addr = map.keySet().toArray(new InetSocketAddress[map.size()])) {
                            result.add(address.getHostName() + ":" + address.getPort());
                        }
                        context.getResult().set(result);
                    }
                    context.stepCompleted();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }
}

