/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ViewExpiredException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.ResponseStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreViewPhase
extends Phase {
    private static final String WEBAPP_ERROR_PAGE_MARKER = "javax.servlet.error.message";
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    private WebConfiguration webConfig;

    @Override
    public PhaseId getId() {
        return PhaseId.RESTORE_VIEW;
    }

    @Override
    public void doPhase(FacesContext facesContext, Lifecycle lifecycle, ListIterator<PhaseListener> listIterator) {
        Util.getViewHandler(facesContext).initView(facesContext);
        super.doPhase(facesContext, lifecycle, listIterator);
    }

    @Override
    public void execute(FacesContext facesContext) throws FacesException {
        boolean bl;
        String string;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Entering RestoreViewPhase");
        }
        if (null == facesContext) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR", new Object[0]));
        }
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (uIViewRoot != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found a pre created view in FacesContext");
            }
            facesContext.getViewRoot().setLocale(facesContext.getExternalContext().getRequestLocale());
            this.doPerComponentActions(facesContext, (UIComponent)uIViewRoot);
            if (!this.isPostback(facesContext)) {
                facesContext.renderResponse();
            }
            return;
        }
        if (Util.isPortletRequest(facesContext)) {
            string = facesContext.getExternalContext().getRequestPathInfo();
            if (string == null) {
                string = facesContext.getExternalContext().getRequestServletPath();
            }
        } else {
            Map map = facesContext.getExternalContext().getRequestMap();
            string = (String)map.get("javax.servlet.include.path_info");
            if (string == null) {
                string = facesContext.getExternalContext().getRequestPathInfo();
            }
            if (string == null) {
                string = (String)map.get("javax.servlet.include.servlet_path");
            }
            if (string == null) {
                string = facesContext.getExternalContext().getRequestServletPath();
            }
        }
        if (string == null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("viewId is null");
            }
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_REQUEST_VIEW_ERROR", new Object[0]));
        }
        boolean bl2 = bl = this.isPostback(facesContext) && !RestoreViewPhase.isErrorPage(facesContext);
        if (bl) {
            ViewHandler viewHandler = Util.getViewHandler(facesContext);
            uIViewRoot = viewHandler.restoreView(facesContext, string);
            if (uIViewRoot == null) {
                if (this.is11CompatEnabled(facesContext)) {
                    uIViewRoot = viewHandler.createView(facesContext, string);
                    facesContext.renderResponse();
                } else {
                    Object[] objectArray = new Object[]{string};
                    throw new ViewExpiredException(MessageUtils.getExceptionMessageString("com.sun.faces.RESTORE_VIEW_ERROR", objectArray), string);
                }
            }
            facesContext.setViewRoot(uIViewRoot);
            this.doPerComponentActions(facesContext, (UIComponent)uIViewRoot);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Postback: Restored view for " + string);
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("New request: creating a view for " + string);
            }
            uIViewRoot = Util.getViewHandler(facesContext).createView(facesContext, string);
            facesContext.setViewRoot(uIViewRoot);
            facesContext.renderResponse();
        }
        assert (null != uIViewRoot);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Exiting RestoreViewPhase");
        }
    }

    protected void doPerComponentActions(FacesContext facesContext, UIComponent uIComponent) {
        ValueExpression valueExpression = uIComponent.getValueExpression("binding");
        if (null != valueExpression) {
            valueExpression.setValue(facesContext.getELContext(), (Object)uIComponent);
        }
        Iterator iterator = uIComponent.getFacetsAndChildren();
        while (iterator.hasNext()) {
            this.doPerComponentActions(facesContext, (UIComponent)iterator.next());
        }
    }

    private boolean isPostback(FacesContext facesContext) {
        String string = facesContext.getApplication().getViewHandler().calculateRenderKitId(facesContext);
        ResponseStateManager responseStateManager = RenderKitUtils.getResponseStateManager(facesContext, string);
        return responseStateManager.isPostback(facesContext);
    }

    private static boolean isErrorPage(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestMap().get(WEBAPP_ERROR_PAGE_MARKER) != null;
    }

    private WebConfiguration getWebConfig(FacesContext facesContext) {
        if (this.webConfig == null) {
            this.webConfig = WebConfiguration.getInstance(facesContext.getExternalContext());
        }
        return this.webConfig;
    }

    private boolean is11CompatEnabled(FacesContext facesContext) {
        return this.getWebConfig(facesContext).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableRestoreView11Compatibility);
    }
}

