/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFVersionTracker
implements Serializable {
    private static Version DEFAULT_VERSION = new Version(1, 2);
    private Map<String, Version> grammarToVersionMap = null;
    private List<Version> versionStack;
    private Map<String, Version> trackedClasses;

    private Map<String, Version> getGrammarToVersionMap() {
        if (null == this.grammarToVersionMap) {
            this.grammarToVersionMap = new HashMap<String, Version>(6);
            this.grammarToVersionMap.put("web-facesconfig_1_0.dtd", new Version(1, 0));
            this.grammarToVersionMap.put("web-facesconfig_1_1.dtd", new Version(1, 1));
            this.grammarToVersionMap.put("web-facesconfig_1_2.xsd", new Version(1, 2));
        }
        return this.grammarToVersionMap;
    }

    private List<Version> getVersionStack() {
        if (null == this.versionStack) {
            this.versionStack = new ArrayList<Version>(){

                @Override
                public String toString() {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Version version : this) {
                        if (null == version) {
                            stringBuilder.append("null\n");
                            continue;
                        }
                        stringBuilder.append(version.toString()).append('\n');
                    }
                    return stringBuilder.toString();
                }
            };
        }
        return this.versionStack;
    }

    Version popJSFVersionNumber() {
        int n;
        int n2;
        List<Version> list = this.getVersionStack();
        assert (null != list);
        Version version = null;
        for (n2 = n = list.size() - 1; n2 >= 0 && null == (version = list.get(n2)); --n2) {
        }
        if (null != version) {
            for (int i = n; i >= n2; --i) {
                list.remove(list.size() - 1);
            }
        }
        return version;
    }

    Version peekJSFVersionNumber() {
        List<Version> list = this.getVersionStack();
        assert (null != list);
        Version version = null;
        for (int i = list.size() - 1; i >= 0 && null == (version = list.get(i)); --i) {
        }
        return version;
    }

    private Map<String, Version> getTrackedClassMap() {
        if (null == this.trackedClasses) {
            this.trackedClasses = new HashMap<String, Version>(){

                @Override
                public String toString() {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Map.Entry entry : this.entrySet()) {
                        Version version = (Version)entry.getValue();
                        stringBuilder.append(entry).append(": ");
                        stringBuilder.append(version.toString()).append('\n');
                    }
                    return stringBuilder.toString();
                }
            };
        }
        return this.trackedClasses;
    }

    void startParse() {
    }

    void endParse() {
        this.popJSFVersionNumber();
    }

    String pushJSFVersionNumberFromGrammar(String string) {
        Map<String, Version> map = this.getGrammarToVersionMap();
        List<Version> list = this.getVersionStack();
        assert (null != map);
        assert (null != list);
        list.add(map.get(string));
        return string;
    }

    void putTrackedClassName(String string) {
        Version version = this.peekJSFVersionNumber();
        if (null == version) {
            version = DEFAULT_VERSION;
        }
        this.getTrackedClassMap().put(string, version);
    }

    public Version getVersionForTrackedClassName(String string) {
        return this.getTrackedClassMap().get(string);
    }

    public Version getCurrentVersion() {
        return DEFAULT_VERSION;
    }

    public static final class Version
    implements Comparable {
        private int majorVersion;
        private int minorVersion;

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public void setMajorVersion(int n) {
            this.majorVersion = n;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }

        public void setMinorVersion(int n) {
            this.minorVersion = n;
        }

        public int compareTo(Object object) {
            int n;
            int n2;
            Version version = (Version)object;
            int n3 = this.getMajorVersion();
            if (n3 < (n2 = version.getMajorVersion())) {
                n = -1;
            } else {
                assert (n3 >= n2);
                if (n3 == n2) {
                    int n4;
                    int n5 = this.getMinorVersion();
                    if (n5 < (n4 = version.getMinorVersion())) {
                        n = -1;
                    } else {
                        assert (n5 >= n4);
                        n = n5 == n4 ? 1 : 0;
                    }
                } else {
                    assert (n3 > n2);
                    n = 1;
                }
            }
            return n;
        }

        public Version(int n, int n2) {
            this.setMajorVersion(n);
            this.setMinorVersion(n2);
        }

        public String toString() {
            return String.valueOf(this.getMajorVersion()) + '.' + this.getMinorVersion();
        }
    }
}

