/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ViewHandlerResponseWrapper;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.jstl.core.Config;

public class ViewHandlerImpl
extends ViewHandler {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private ApplicationAssociate associate;
    private String contextDefaultSuffix;
    private int bufSize = -1;

    public ViewHandlerImpl() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created ViewHandler instance ");
        }
    }

    public void initView(FacesContext facesContext) throws FacesException {
        if (facesContext.getExternalContext().getRequestCharacterEncoding() == null) {
            super.initView(facesContext);
        }
    }

    public void renderView(FacesContext facesContext, UIViewRoot uIViewRoot) throws IOException, FacesException {
        ViewHandlerResponseWrapper viewHandlerResponseWrapper;
        Object object;
        if (!uIViewRoot.isRendered()) {
            return;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        ServletRequest servletRequest = (ServletRequest)externalContext.getRequest();
        ServletResponse servletResponse = (ServletResponse)externalContext.getResponse();
        try {
            if (this.executePageToBuildView(facesContext, uIViewRoot)) {
                servletResponse.flushBuffer();
                ApplicationAssociate applicationAssociate = this.getAssociate(facesContext);
                if (applicationAssociate != null) {
                    applicationAssociate.responseRendered();
                }
                return;
            }
        }
        catch (IOException iOException) {
            throw new FacesException((Throwable)iOException);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Completed building view for : \n" + uIViewRoot.getViewId());
        }
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderKitFactory.getRenderKit(facesContext, uIViewRoot.getRenderKitId());
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        if (this.bufSize == -1) {
            object = WebConfiguration.getInstance(facesContext.getExternalContext());
            try {
                this.bufSize = Integer.parseInt(((WebConfiguration)object).getOptionValue(WebConfiguration.WebContextInitParameter.ResponseBufferSize));
            }
            catch (NumberFormatException numberFormatException) {
                this.bufSize = Integer.parseInt(WebConfiguration.WebContextInitParameter.ResponseBufferSize.getDefaultValue());
            }
        }
        object = new WriteBehindStateWriter(servletResponse.getWriter(), facesContext, this.bufSize);
        ResponseWriter responseWriter2 = null != responseWriter ? responseWriter.cloneWithWriter((Writer)object) : renderKit.createResponseWriter((Writer)object, null, servletRequest.getCharacterEncoding());
        facesContext.setResponseWriter(responseWriter2);
        responseWriter2.startDocument();
        this.doRenderView(facesContext, uIViewRoot);
        responseWriter2.endDocument();
        if (((WriteBehindStateWriter)object).stateWritten()) {
            ((WriteBehindStateWriter)object).flushToWriter();
        }
        ((WriteBehindStateWriter)object).release();
        if (null != responseWriter) {
            facesContext.setResponseWriter(responseWriter);
        }
        if (null != (viewHandlerResponseWrapper = (ViewHandlerResponseWrapper)((Object)RequestStateManager.remove(facesContext, "com.sun.faces.AFTER_VIEW_CONTENT")))) {
            viewHandlerResponseWrapper.flushToWriter(servletResponse.getWriter(), servletResponse.getCharacterEncoding());
        }
        servletResponse.flushBuffer();
    }

    private void doRenderView(FacesContext facesContext, UIViewRoot uIViewRoot) throws IOException, FacesException {
        ApplicationAssociate applicationAssociate = this.getAssociate(facesContext);
        if (null != applicationAssociate) {
            applicationAssociate.responseRendered();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "About to render view " + uIViewRoot.getViewId());
        }
        uIViewRoot.encodeAll(facesContext);
    }

    public UIViewRoot restoreView(FacesContext facesContext, String string) {
        if (facesContext == null) {
            String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(string2);
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String string3 = Util.getFacesMapping(facesContext);
        UIViewRoot uIViewRoot = null;
        if (string3 != null) {
            string = !Util.isPrefixMapped(string3) ? this.convertViewId(facesContext, string) : this.normalizeRequestURI(string, string3);
        }
        if (externalContext.getRequestPathInfo() == null && string3 != null && Util.isPrefixMapped(string3)) {
            try {
                facesContext.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Response Complete for" + string);
                }
                externalContext.redirect(externalContext.getRequestContextPath());
            }
            catch (IOException iOException) {
                throw new FacesException((Throwable)iOException);
            }
        } else {
            ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
            String string4 = viewHandler.calculateRenderKitId(facesContext);
            uIViewRoot = Util.getStateManager(facesContext).restoreView(facesContext, string, string4);
        }
        return uIViewRoot;
    }

    public UIViewRoot createView(FacesContext facesContext, String string) {
        Object object;
        if (facesContext == null) {
            String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(string2);
        }
        UIViewRoot uIViewRoot = (UIViewRoot)facesContext.getApplication().createComponent("javax.faces.ViewRoot");
        if (string != null) {
            object = Util.getFacesMapping(facesContext);
            if (object != null) {
                if (!Util.isPrefixMapped((String)object)) {
                    string = this.convertViewId(facesContext, string);
                } else {
                    string = this.normalizeRequestURI(string, (String)object);
                    if (!Util.isPortletRequest(facesContext) && string.equals(object)) {
                        this.send404Error(facesContext);
                    }
                }
            }
            uIViewRoot.setViewId(string);
        }
        object = null;
        String string3 = null;
        if (facesContext.getViewRoot() != null) {
            object = facesContext.getViewRoot().getLocale();
            string3 = facesContext.getViewRoot().getRenderKitId();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created new view for " + string);
        }
        if (object == null) {
            object = facesContext.getApplication().getViewHandler().calculateLocale(facesContext);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Locale for this view as determined by calculateLocale " + ((Locale)object).toString());
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using locale from previous view " + ((Locale)object).toString());
        }
        if (string3 == null) {
            string3 = facesContext.getApplication().getViewHandler().calculateRenderKitId(facesContext);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("RenderKitId for this view as determined by calculateRenderKitId " + string3);
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using renderKitId from previous view " + string3);
        }
        uIViewRoot.setLocale((Locale)object);
        uIViewRoot.setRenderKitId(string3);
        return uIViewRoot;
    }

    private boolean executePageToBuildView(FacesContext facesContext, UIViewRoot uIViewRoot) throws IOException {
        if (null == facesContext) {
            String string = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(string);
        }
        if (null == uIViewRoot) {
            String string = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "viewToExecute");
            throw new NullPointerException(string);
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        Map<String, Object> map = RequestStateManager.getStateMap(facesContext);
        if ("/*".equals(map.get("com.sun.faces.INVOCATION_PATH"))) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.FACES_SERVLET_MAPPING_INCORRECT", new Object[0]));
        }
        String string = uIViewRoot.getViewId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("About to execute view " + string);
        }
        if (externalContext.getRequest() instanceof ServletRequest) {
            Config.set((ServletRequest)((ServletRequest)externalContext.getRequest()), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)facesContext.getViewRoot().getLocale());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Before dispacthMessage to viewId " + string);
        }
        Object object = externalContext.getResponse();
        ViewHandlerResponseWrapper viewHandlerResponseWrapper = ViewHandlerImpl.getWrapper(externalContext);
        externalContext.setResponse((Object)viewHandlerResponseWrapper);
        externalContext.dispatch(string);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("After dispacthMessage to viewId " + string);
        }
        externalContext.setResponse(object);
        if (viewHandlerResponseWrapper.getStatus() < 200 || viewHandlerResponseWrapper.getStatus() > 299) {
            viewHandlerResponseWrapper.flushContentToWrappedResponse();
            return true;
        }
        map.put("com.sun.faces.AFTER_VIEW_CONTENT", (Object)viewHandlerResponseWrapper);
        return false;
    }

    public Locale calculateLocale(FacesContext facesContext) {
        Locale locale;
        if (facesContext == null) {
            String string = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(string);
        }
        Locale locale2 = null;
        Iterator iterator = facesContext.getExternalContext().getRequestLocales();
        while (iterator.hasNext() && (locale2 = this.findMatch(facesContext, locale = (Locale)iterator.next())) == null) {
        }
        if (locale2 == null) {
            locale2 = facesContext.getApplication().getDefaultLocale() == null ? Locale.getDefault() : facesContext.getApplication().getDefaultLocale();
        }
        return locale2;
    }

    public String calculateRenderKitId(FacesContext facesContext) {
        if (facesContext == null) {
            String string = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(string);
        }
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        String string = (String)map.get("javax.faces.RenderKitId");
        if (string == null && null == (string = facesContext.getApplication().getDefaultRenderKitId())) {
            string = "HTML_BASIC";
        }
        return string;
    }

    protected Locale findMatch(FacesContext facesContext, Locale locale) {
        Locale locale2;
        Locale locale3 = null;
        Iterator iterator = facesContext.getApplication().getSupportedLocales();
        while (iterator.hasNext()) {
            locale2 = (Locale)iterator.next();
            if (locale.equals(locale2)) {
                locale3 = locale2;
                break;
            }
            if (!locale.getLanguage().equals(locale2.getLanguage()) || locale2.getCountry().length() != 0) continue;
            locale3 = locale2;
        }
        if (null == locale3 && (locale2 = facesContext.getApplication().getDefaultLocale()) != null) {
            if (locale.equals(locale2)) {
                locale3 = locale2;
            } else if (locale.getLanguage().equals(locale2.getLanguage()) && locale2.getCountry().length() == 0) {
                locale3 = locale2;
            }
        }
        return locale3;
    }

    public void writeState(FacesContext facesContext) throws IOException {
        WriteBehindStateWriter writeBehindStateWriter;
        if (facesContext == null) {
            String string = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(string);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Begin writing marker for viewId " + facesContext.getViewRoot().getViewId());
        }
        if ((writeBehindStateWriter = WriteBehindStateWriter.getCurrentInstance()) != null) {
            writeBehindStateWriter.writingState();
        }
        facesContext.getResponseWriter().write("~com.sun.faces.saveStateFieldMarker~");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("End writing marker for viewId " + facesContext.getViewRoot().getViewId());
        }
    }

    public String getActionURL(FacesContext facesContext, String string) {
        if (facesContext == null) {
            String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(string2);
        }
        if (string == null) {
            String string3 = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "viewId");
            throw new NullPointerException(string3);
        }
        if (string.charAt(0) != '/') {
            String string4 = MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_VIEW_ID", string);
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "jsf.illegal_view_id_error", string);
            }
            throw new IllegalArgumentException(string4);
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String string5 = externalContext.getRequestContextPath();
        String string6 = Util.getFacesMapping(facesContext);
        if (string6 == null) {
            return string5 + string;
        }
        if (Util.isPrefixMapped(string6)) {
            if (string6.equals("/*")) {
                return string5 + string;
            }
            return string5 + string6 + string;
        }
        if (string.endsWith(this.getDefaultSuffix(facesContext))) {
            return string5 + string.substring(0, string.lastIndexOf(46)) + string6;
        }
        return string5 + string;
    }

    public String getResourceURL(FacesContext facesContext, String string) {
        ExternalContext externalContext = facesContext.getExternalContext();
        if (string.startsWith("/")) {
            return externalContext.getRequestContextPath() + string;
        }
        return string;
    }

    private String normalizeRequestURI(String string, String string2) {
        if (string2 == null || !Util.isPrefixMapped(string2)) {
            return string;
        }
        int n = string2.length() + 1;
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(string2).append('/');
        String string3 = stringBuilder.toString();
        boolean bl = false;
        while (string.startsWith(string3)) {
            if (!bl && logger.isLoggable(Level.WARNING)) {
                bl = true;
                logger.log(Level.WARNING, "jsf.viewhandler.requestpath.recursion", new Object[]{string, string2});
            }
            string = string.substring(n - 1);
        }
        return string;
    }

    private void send404Error(FacesContext facesContext) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        try {
            facesContext.responseComplete();
            httpServletResponse.sendError(404);
        }
        catch (IOException iOException) {
            throw new FacesException((Throwable)iOException);
        }
    }

    private String convertViewId(FacesContext facesContext, String string) {
        String string2 = string;
        String string3 = this.getDefaultSuffix(facesContext);
        if (!string2.endsWith(string3)) {
            StringBuilder stringBuilder = new StringBuilder(string2);
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                stringBuilder.replace(n, string2.length(), string3);
            } else {
                stringBuilder.append(string3);
            }
            string2 = stringBuilder.toString();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("viewId after appending the context suffix " + string2);
            }
        }
        return string2;
    }

    private String getDefaultSuffix(FacesContext facesContext) {
        if (this.contextDefaultSuffix == null) {
            this.contextDefaultSuffix = WebConfiguration.getInstance(facesContext.getExternalContext()).getOptionValue(WebConfiguration.WebContextInitParameter.JspDefaultSuffix);
            if (this.contextDefaultSuffix == null) {
                this.contextDefaultSuffix = ".jsp";
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("contextDefaultSuffix " + this.contextDefaultSuffix);
            }
        }
        return this.contextDefaultSuffix;
    }

    private ApplicationAssociate getAssociate(FacesContext facesContext) {
        if (this.associate == null) {
            this.associate = ApplicationAssociate.getInstance(facesContext.getExternalContext());
        }
        return this.associate;
    }

    private static ViewHandlerResponseWrapper getWrapper(ExternalContext externalContext) {
        Object object = externalContext.getResponse();
        if (object instanceof HttpServletResponse) {
            return new ViewHandlerResponseWrapper((HttpServletResponse)object);
        }
        throw new IllegalArgumentException();
    }

    private static final class WriteBehindStateWriter
    extends Writer {
        private static final int STATE_MARKER_LEN = "~com.sun.faces.saveStateFieldMarker~".length();
        private static final ThreadLocal<WriteBehindStateWriter> CUR_WRITER = new ThreadLocal();
        private Writer out;
        private Writer orig;
        private FastStringWriter fWriter;
        private boolean stateWritten;
        private int bufSize;
        private char[] buf;
        private FacesContext context;

        public WriteBehindStateWriter(Writer writer, FacesContext facesContext, int n) {
            this.out = writer;
            this.orig = writer;
            this.context = facesContext;
            this.bufSize = n;
            this.buf = new char[n];
            CUR_WRITER.set(this);
        }

        public void write(int n) throws IOException {
            this.out.write(n);
        }

        public void write(char[] cArray) throws IOException {
            this.out.write(cArray);
        }

        public void write(String string) throws IOException {
            this.out.write(string);
        }

        public void write(String string, int n, int n2) throws IOException {
            this.out.write(string, n, n2);
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            this.out.write(cArray, n, n2);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public static WriteBehindStateWriter getCurrentInstance() {
            return CUR_WRITER.get();
        }

        public void release() {
            CUR_WRITER.remove();
        }

        public void writingState() {
            if (!this.stateWritten) {
                this.stateWritten = true;
                this.fWriter = new FastStringWriter(1024);
                this.out = this.fWriter;
            }
        }

        public boolean stateWritten() {
            return this.stateWritten;
        }

        public void flushToWriter() throws IOException {
            StateManager stateManager = Util.getStateManager(this.context);
            ResponseWriter responseWriter = this.context.getResponseWriter();
            FastStringWriter fastStringWriter = new FastStringWriter(stateManager.isSavingStateInClient(this.context) ? this.bufSize : 128);
            this.context.setResponseWriter(responseWriter.cloneWithWriter((Writer)fastStringWriter));
            stateManager.writeState(this.context, stateManager.saveView(this.context));
            this.context.setResponseWriter(responseWriter);
            StringBuilder stringBuilder = this.fWriter.getBuffer();
            int n = stringBuilder.length();
            StringBuilder stringBuilder2 = fastStringWriter.getBuffer();
            int n2 = stringBuilder2.length();
            int n3 = 0;
            int n4 = WriteBehindStateWriter.getNextDelimiterIndex(stringBuilder, n3);
            while (n3 < n) {
                int n5;
                if (n4 != -1) {
                    if (n4 > n3 && n4 - n3 > this.bufSize) {
                        stringBuilder.getChars(n3, n3 + this.bufSize, this.buf, 0);
                        this.orig.write(this.buf);
                        n3 += this.bufSize;
                        continue;
                    }
                    stringBuilder.getChars(n3, n4, this.buf, 0);
                    n5 = n4 - n3;
                    this.orig.write(this.buf, 0, n5);
                    if (stringBuilder.indexOf("~com.sun.faces.saveStateFieldMarker~", n3) == n4) {
                        int n6 = 0;
                        while (n6 < n2) {
                            if (n2 - n6 > this.bufSize) {
                                stringBuilder2.getChars(n6, n6 + this.bufSize, this.buf, 0);
                                this.orig.write(this.buf);
                                n6 += this.bufSize;
                                continue;
                            }
                            int n7 = n2 - n6;
                            stringBuilder2.getChars(n6, n2, this.buf, 0);
                            this.orig.write(this.buf, 0, n7);
                            n6 += n7;
                        }
                        n4 = WriteBehindStateWriter.getNextDelimiterIndex(stringBuilder, n3 += n5 + STATE_MARKER_LEN);
                        continue;
                    }
                    n3 = n4;
                    n4 = WriteBehindStateWriter.getNextDelimiterIndex(stringBuilder, n4 + 1);
                    continue;
                }
                if (n - n3 > this.bufSize) {
                    stringBuilder.getChars(n3, n3 + this.bufSize, this.buf, 0);
                    this.orig.write(this.buf);
                    n3 += this.bufSize;
                    continue;
                }
                stringBuilder.getChars(n3, n, this.buf, 0);
                n5 = n - n3;
                this.orig.write(this.buf, 0, n5);
                n3 += n5 + 1;
            }
            this.out = this.orig;
        }

        private static int getNextDelimiterIndex(StringBuilder stringBuilder, int n) {
            return stringBuilder.indexOf("~", n);
        }
    }
}

