/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import java.io.IOException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.patching.PatchMessages;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstallationManagerService;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.management.PatchManagementMessages;
import org.jboss.as.patching.management.PatchResourceDefinition;
import org.jboss.as.patching.metadata.Identity;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.tool.PatchingHistory;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class PatchInfoHandler
implements OperationStepHandler {
    public static final PatchInfoHandler INSTANCE = new PatchInfoHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PatchableTarget.TargetInfo info;
        String patchId = PatchResourceDefinition.PATCH_ID.resolveModelAttribute(context, operation).asString();
        boolean verbose = PatchResourceDefinition.VERBOSE.resolveModelAttribute(context, operation).asBoolean();
        InstallationManager mgr = this.getInstallationManager(context);
        if (mgr == null) {
            throw new OperationFailedException(PatchManagementMessages.MESSAGES.failedToLoadIdentity());
        }
        try {
            info = mgr.getIdentity().loadTargetInfo();
        }
        catch (IOException e) {
            throw new OperationFailedException(PatchManagementMessages.MESSAGES.failedToLoadIdentity(), (Throwable)e);
        }
        ModelNode result = null;
        PatchingHistory.Iterator i = PatchingHistory.Factory.iterator(mgr, info);
        while (i.hasNext()) {
            PatchingHistory.Entry entry = (PatchingHistory.Entry)i.next();
            if (!patchId.equals(entry.getPatchId())) continue;
            result = new ModelNode();
            result.get("patch-id").set(entry.getPatchId());
            result.get("type").set(entry.getType().getName());
            result.get("description").set(entry.getMetadata().getDescription());
            String link = entry.getMetadata().getLink();
            if (link != null) {
                result.get("link").set(link);
            }
            Identity identity = entry.getMetadata().getIdentity();
            result.get("identity-name").set(identity.getName());
            result.get("identity-version").set(identity.getVersion());
            if (verbose) {
                ModelNode list = result.get("elements").setEmptyList();
                Patch metadata = entry.getMetadata();
                for (PatchElement e : metadata.getElements()) {
                    ModelNode element = new ModelNode();
                    element.get("patch-id").set(e.getId());
                    element.get("type").set(e.getProvider().isAddOn() ? "add-on" : "layer");
                    element.get("name").set(e.getProvider().getName());
                    element.get("description").set(e.getDescription());
                    list.add(element);
                }
            }
            context.getResult().set(result);
            break;
        }
        if (result == null) {
            context.getFailureDescription().set(PatchMessages.MESSAGES.patchNotFoundInHistory(patchId).getLocalizedMessage());
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    private InstallationManager getInstallationManager(OperationContext ctx) {
        ServiceController imController = ctx.getServiceRegistry(false).getRequiredService(InstallationManagerService.NAME);
        while (imController != null && imController.getState() == ServiceController.State.UP) {
            try {
                return (InstallationManager)imController.getValue();
            }
            catch (IllegalStateException illegalStateException) {
            }
        }
        return null;
    }
}

