/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.management.remote.JMXServiceURL;

public class Util {
    private static Integer DEFAULT_TIMEOUT_SECONDS = 30;

    private Util() {
    }

    public static URI convert(JMXServiceURL serviceUrl) throws IOException {
        String scheme = "remote";
        String host = serviceUrl.getHost();
        int port = serviceUrl.getPort();
        try {
            return new URI(scheme, null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to create connection URI", e);
        }
    }

    public static Integer getTimeoutValue(Timeout property, Map<String, ?> environment) {
        Integer timeoutSeconds = Integer.getInteger(property.toString());
        if (timeoutSeconds != null) {
            return timeoutSeconds;
        }
        timeoutSeconds = Integer.getInteger(Timeout.GENERIC.toString());
        if (timeoutSeconds != null) {
            return timeoutSeconds;
        }
        if (environment != null) {
            timeoutSeconds = Util.getInteger(environment.get(property.toString()));
            if (timeoutSeconds != null) {
                return timeoutSeconds;
            }
            timeoutSeconds = Util.getInteger(environment.get(Timeout.GENERIC.toString()));
            if (timeoutSeconds != null) {
                return timeoutSeconds;
            }
        }
        return DEFAULT_TIMEOUT_SECONDS;
    }

    public static Integer getInteger(Object object) {
        try {
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof String) {
                return Integer.valueOf((String)object);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static enum Timeout {
        GENERIC("org.jboss.remoting-jmx.timeout"),
        CHANNEL("org.jboss.remoting-jmx.timeout.channel"),
        CONNECTION("org.jboss.remoting-jmx.timeout.connection"),
        VERSIONED_CONNECTION("org.jboss.remoting-jmx.timeout.versioned.connection");

        private String propertyName;

        private Timeout(String propertyName) {
            this.propertyName = propertyName;
        }

        public String toString() {
            return this.propertyName;
        }
    }
}

