/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.List;
import org.jboss.as.cli.ArgumentValueConverter;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.dmr.ModelNode;

public class ArgumentWithValue
extends ArgumentWithoutValue {
    private final CommandLineCompleter valueCompleter;
    private final ArgumentValueConverter valueConverter;

    public ArgumentWithValue(CommandHandlerWithArguments handler, String fullName) {
        this(handler, null, ArgumentValueConverter.DEFAULT, fullName, null);
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, CommandLineCompleter valueCompleter, String fullName) {
        this(handler, valueCompleter, ArgumentValueConverter.DEFAULT, fullName, null);
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, CommandLineCompleter valueCompleter, ArgumentValueConverter valueConverter, String fullName) {
        this(handler, valueCompleter, valueConverter, fullName, null);
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, int index, String fullName) {
        this(handler, null, index, fullName);
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, CommandLineCompleter valueCompleter, int index, String fullName) {
        super(handler, index, fullName);
        this.valueCompleter = valueCompleter;
        this.valueConverter = ArgumentValueConverter.DEFAULT;
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, CommandLineCompleter valueCompleter, ArgumentValueConverter valueConverter, String fullName, String shortName) {
        super(handler, fullName, shortName);
        this.valueCompleter = valueCompleter;
        this.valueConverter = valueConverter;
    }

    @Override
    public CommandLineCompleter getValueCompleter() {
        return this.valueCompleter;
    }

    @Override
    public String getValue(ParsedCommandLine args, boolean required) throws CommandFormatException {
        String value = null;
        if (args.hasProperties()) {
            List<String> others;
            if (this.index >= 0 && (others = args.getOtherProperties()).size() > this.index) {
                return others.get(this.index);
            }
            value = args.getPropertyValue(this.fullName);
            if (value == null && this.shortName != null) {
                value = args.getPropertyValue(this.shortName);
            }
        }
        if (required && value == null && !this.isPresent(args)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Required argument ");
            buf.append('\'').append(this.fullName).append('\'');
            buf.append(" is missing.");
            throw new CommandFormatException(buf.toString());
        }
        return value;
    }

    public ModelNode toModelNode(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine parsedLine = ctx.getParsedCommandLine();
        String value = this.getValue(parsedLine, false);
        if (value == null) {
            return null;
        }
        return this.valueConverter.fromString(ctx, value);
    }

    @Override
    public boolean isValueRequired() {
        return true;
    }

    @Override
    public boolean isValueComplete(ParsedCommandLine args) throws CommandFormatException {
        if (!this.isPresent(args)) {
            return false;
        }
        if (this.index >= 0) {
            int size = args.getOtherProperties().size();
            if (this.index >= size) {
                return false;
            }
            if (this.index < size - 1) {
                return true;
            }
            return !args.getOtherProperties().get(this.index).equals(args.getLastParsedPropertyValue());
        }
        if (this.fullName.equals(args.getLastParsedPropertyName())) {
            return false;
        }
        return this.shortName == null || !this.shortName.equals(args.getLastParsedPropertyName());
    }

    public ArgumentValueConverter getValueConverter() {
        return this.valueConverter;
    }
}

