/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.writercache.lru;

import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.writercache.TaxonomyWriterCache;
import org.apache.lucene.facet.taxonomy.writercache.lru.NameHashIntCacheLRU;
import org.apache.lucene.facet.taxonomy.writercache.lru.NameIntCacheLRU;

public class LruTaxonomyWriterCache
implements TaxonomyWriterCache {
    private NameIntCacheLRU cache;

    public LruTaxonomyWriterCache(int cacheSize) {
        this(cacheSize, LRUType.LRU_HASHED);
    }

    public LruTaxonomyWriterCache(int cacheSize, LRUType lruType) {
        this.cache = lruType == LRUType.LRU_HASHED ? new NameHashIntCacheLRU(cacheSize) : new NameIntCacheLRU(cacheSize);
    }

    @Override
    public boolean hasRoom(int n) {
        return n <= this.cache.getMaxSize() - this.cache.getSize();
    }

    @Override
    public void close() {
        this.cache.clear();
        this.cache = null;
    }

    @Override
    public int get(CategoryPath categoryPath) {
        Integer res = this.cache.get(categoryPath);
        if (res == null) {
            return -1;
        }
        return res;
    }

    @Override
    public int get(CategoryPath categoryPath, int length) {
        Integer res;
        if (length < 0 || length > categoryPath.length()) {
            length = categoryPath.length();
        }
        if ((res = this.cache.get(new CategoryPath(categoryPath, length))) == null) {
            return -1;
        }
        return res;
    }

    @Override
    public boolean put(CategoryPath categoryPath, int ordinal) {
        boolean ret = this.cache.put(categoryPath, new Integer(ordinal));
        if (ret) {
            this.cache.makeRoomLRU();
        }
        return ret;
    }

    @Override
    public boolean put(CategoryPath categoryPath, int prefixLen, int ordinal) {
        boolean ret = this.cache.put(categoryPath, prefixLen, new Integer(ordinal));
        if (ret) {
            this.cache.makeRoomLRU();
        }
        return ret;
    }

    public static enum LRUType {
        LRU_HASHED,
        LRU_STRING;

    }
}

