/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class TemporaryObjectAllocator<T> {
    ConcurrentLinkedQueue<T> pool = new ConcurrentLinkedQueue();
    int maxObjects;

    public TemporaryObjectAllocator(int maxObjects) {
        this.maxObjects = maxObjects;
    }

    protected abstract T create();

    protected abstract void clear(T var1);

    public final T allocate() {
        T object = this.pool.poll();
        if (object == null) {
            return this.create();
        }
        this.clear(object);
        return object;
    }

    public final void free(T object) {
        if (this.pool.size() < this.maxObjects && object != null) {
            this.pool.add(object);
        }
    }
}

