/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FloatArrayAllocator;
import org.apache.lucene.facet.search.IntArrayAllocator;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.search.StandardFacetsAccumulator;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.search.sampling.RandomSampler;
import org.apache.lucene.facet.search.sampling.Sampler;
import org.apache.lucene.facet.search.sampling.SamplingAccumulator;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

public final class AdaptiveFacetsAccumulator
extends StandardFacetsAccumulator {
    private Sampler sampler = new RandomSampler();

    public AdaptiveFacetsAccumulator(FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader) {
        super(searchParams, indexReader, taxonomyReader);
    }

    public AdaptiveFacetsAccumulator(FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader, IntArrayAllocator intArrayAllocator, FloatArrayAllocator floatArrayAllocator) {
        super(searchParams, indexReader, taxonomyReader, intArrayAllocator, floatArrayAllocator);
    }

    public void setSampler(Sampler sampler) {
        this.sampler = sampler;
    }

    @Override
    public List<FacetResult> accumulate(ScoredDocIDs docids) throws IOException {
        FacetsAccumulator delegee = this.appropriateFacetCountingAccumulator(docids);
        if (delegee == this) {
            return super.accumulate(docids);
        }
        return delegee.accumulate(docids);
    }

    private FacetsAccumulator appropriateFacetCountingAccumulator(ScoredDocIDs docids) {
        if (!this.mayComplement()) {
            return this;
        }
        if (this.sampler == null || !this.sampler.shouldSample(docids)) {
            return this;
        }
        SamplingAccumulator samplingAccumulator = new SamplingAccumulator(this.sampler, this.searchParams, this.indexReader, this.taxonomyReader);
        samplingAccumulator.setComplementThreshold(this.getComplementThreshold());
        return samplingAccumulator;
    }

    public final Sampler getSampler() {
        return this.sampler;
    }
}

