/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.example.association;

import java.util.List;
import org.apache.lucene.facet.example.association.AssociationUtils;
import org.apache.lucene.facet.example.simple.SimpleSearcher;
import org.apache.lucene.facet.search.params.association.AssociationFloatSumFacetRequest;
import org.apache.lucene.facet.search.params.association.AssociationIntSumFacetRequest;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;

public class AssociationSearcher {
    public static List<FacetResult> searchSumIntAssociation(Directory indexDir, Directory taxoDir) throws Exception {
        IndexReader indexReader = IndexReader.open((Directory)indexDir);
        DirectoryTaxonomyReader taxo = new DirectoryTaxonomyReader(taxoDir);
        AssociationIntSumFacetRequest facetRequest = new AssociationIntSumFacetRequest(new CategoryPath("tags"), 10);
        List<FacetResult> res = SimpleSearcher.searchWithRequest(indexReader, taxo, AssociationUtils.assocIndexingParams, facetRequest);
        taxo.close();
        indexReader.close();
        return res;
    }

    public static List<FacetResult> searchSumFloatAssociation(Directory indexDir, Directory taxoDir) throws Exception {
        IndexReader indexReader = IndexReader.open((Directory)indexDir);
        DirectoryTaxonomyReader taxo = new DirectoryTaxonomyReader(taxoDir);
        AssociationFloatSumFacetRequest facetRequest = new AssociationFloatSumFacetRequest(new CategoryPath("genre"), 10);
        List<FacetResult> res = SimpleSearcher.searchWithRequest(indexReader, taxo, AssociationUtils.assocIndexingParams, facetRequest);
        taxo.close();
        indexReader.close();
        return res;
    }
}

