/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.enhancements.association;

import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.facet.enhancements.CategoryEnhancement;
import org.apache.lucene.facet.enhancements.association.AssociationListTokenizer;
import org.apache.lucene.facet.enhancements.association.AssociationProperty;
import org.apache.lucene.facet.enhancements.params.EnhancementsIndexingParams;
import org.apache.lucene.facet.index.attributes.CategoryAttribute;
import org.apache.lucene.facet.index.attributes.CategoryProperty;
import org.apache.lucene.facet.index.streaming.CategoryListTokenizer;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.util.Vint8;

public class AssociationEnhancement
implements CategoryEnhancement {
    static final String CATEGORY_LIST_TERM_TEXT = "CATEGORY_ASSOCIATION_LIST";
    private static final HashSet<Class<? extends CategoryProperty>> ASSOCIATION_PROPERTY_CLASSES = new HashSet();
    private static final HashSet<Class<? extends CategoryProperty>> NON_ASSOCIATION_PROPERTY_CLASSES = new HashSet();

    public static boolean isAssociationProperty(Class<? extends CategoryProperty> clazz) {
        if (ASSOCIATION_PROPERTY_CLASSES.contains(clazz)) {
            return true;
        }
        if (NON_ASSOCIATION_PROPERTY_CLASSES.contains(clazz)) {
            return false;
        }
        if (AssociationProperty.class.isAssignableFrom(clazz)) {
            ASSOCIATION_PROPERTY_CLASSES.add(clazz);
            return true;
        }
        NON_ASSOCIATION_PROPERTY_CLASSES.add(clazz);
        return false;
    }

    @Override
    public boolean generatesCategoryList() {
        return true;
    }

    @Override
    public String getCategoryListTermText() {
        return CATEGORY_LIST_TERM_TEXT;
    }

    @Override
    public CategoryListTokenizer getCategoryListTokenizer(TokenStream tokenizer, EnhancementsIndexingParams indexingParams, TaxonomyWriter taxonomyWriter) {
        return new AssociationListTokenizer(tokenizer, indexingParams, this);
    }

    @Override
    public byte[] getCategoryTokenBytes(CategoryAttribute categoryAttribute) {
        AssociationProperty property = AssociationEnhancement.getAssociationProperty(categoryAttribute);
        if (property == null) {
            return null;
        }
        int association = property.getAssociation();
        int bytesNeeded = Vint8.bytesNeeded(association);
        byte[] buffer = new byte[bytesNeeded];
        Vint8.encode(association, buffer, 0);
        return buffer;
    }

    public static AssociationProperty getAssociationProperty(CategoryAttribute categoryAttribute) {
        AssociationProperty property = null;
        Set<Class<? extends CategoryProperty>> propertyClasses = categoryAttribute.getPropertyClasses();
        if (propertyClasses == null) {
            return null;
        }
        for (Class<? extends CategoryProperty> clazz : propertyClasses) {
            if (!AssociationEnhancement.isAssociationProperty(clazz)) continue;
            property = (AssociationProperty)categoryAttribute.getProperty(clazz);
            break;
        }
        return property;
    }

    @Override
    public Object extractCategoryTokenData(byte[] buffer, int offset, int length) {
        if (length == 0) {
            return null;
        }
        Integer i = Vint8.decode(buffer, new Vint8.Position(offset));
        return i;
    }

    @Override
    public Class<? extends CategoryProperty> getRetainableProperty() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof AssociationEnhancement;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

