/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.SpellingOptions;
import org.apache.solr.spelling.SpellingResult;

public abstract class SolrSpellChecker {
    public static final String DICTIONARY_NAME = "name";
    public static final String DEFAULT_DICTIONARY_NAME = "default";
    public static final String FIELD = "field";
    public static final String FIELD_TYPE = "fieldType";
    protected String name;
    protected Analyzer analyzer;
    protected String field;
    protected String fieldTypeName;

    public String init(NamedList config, SolrCore core) {
        this.name = (String)config.get(DICTIONARY_NAME);
        if (this.name == null) {
            this.name = DEFAULT_DICTIONARY_NAME;
        }
        this.field = (String)config.get(FIELD);
        if (this.field != null && core.getSchema().getFieldTypeNoEx(this.field) != null) {
            this.analyzer = core.getSchema().getFieldType(this.field).getQueryAnalyzer();
        }
        this.fieldTypeName = (String)config.get(FIELD_TYPE);
        if (core.getSchema().getFieldTypes().containsKey(this.fieldTypeName)) {
            FieldType fieldType = core.getSchema().getFieldTypes().get(this.fieldTypeName);
            this.analyzer = fieldType.getQueryAnalyzer();
        }
        if (this.analyzer == null) {
            this.analyzer = new WhitespaceAnalyzer(core.getSolrConfig().luceneMatchVersion);
        }
        return this.name;
    }

    public Analyzer getQueryAnalyzer() {
        return this.analyzer;
    }

    public String getDictionaryName() {
        return this.name;
    }

    public abstract void reload(SolrCore var1, SolrIndexSearcher var2) throws IOException;

    public abstract void build(SolrCore var1, SolrIndexSearcher var2);

    @Deprecated
    public SpellingResult getSuggestions(Collection<Token> tokens, IndexReader reader) throws IOException {
        return this.getSuggestions(tokens, reader, 1, false, false);
    }

    @Deprecated
    public SpellingResult getSuggestions(Collection<Token> tokens, IndexReader reader, int count) throws IOException {
        return this.getSuggestions(tokens, reader, count, false, false);
    }

    @Deprecated
    public SpellingResult getSuggestions(Collection<Token> tokens, IndexReader reader, boolean onlyMorePopular, boolean extendedResults) throws IOException {
        return this.getSuggestions(tokens, reader, 1, onlyMorePopular, extendedResults);
    }

    @Deprecated
    public abstract SpellingResult getSuggestions(Collection<Token> var1, IndexReader var2, int var3, boolean var4, boolean var5) throws IOException;

    public SpellingResult getSuggestions(SpellingOptions options) throws IOException {
        return this.getSuggestions(options.tokens, options.reader, options.count, options.onlyMorePopular, options.extendedResults);
    }
}

