/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Searcher;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public abstract class MultiFloatFunction
extends ValueSource {
    protected final ValueSource[] sources;

    public MultiFloatFunction(ValueSource[] sources) {
        this.sources = sources;
    }

    protected abstract String name();

    protected abstract float func(int var1, DocValues[] var2);

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name()).append('(');
        boolean firstTime = true;
        for (ValueSource source : this.sources) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(',');
            }
            sb.append(source);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues[] valsArr = new DocValues[this.sources.length];
        for (int i = 0; i < this.sources.length; ++i) {
            valsArr[i] = this.sources[i].getValues(context, reader);
        }
        return new DocValues(){

            @Override
            public float floatVal(int doc) {
                return MultiFloatFunction.this.func(doc, valsArr);
            }

            @Override
            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            @Override
            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            @Override
            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            @Override
            public String toString(int doc) {
                StringBuilder sb = new StringBuilder();
                sb.append(MultiFloatFunction.this.name()).append('(');
                boolean firstTime = true;
                for (DocValues vals : valsArr) {
                    if (firstTime) {
                        firstTime = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(vals.toString(doc));
                }
                sb.append(')');
                return sb.toString();
            }
        };
    }

    @Override
    public void createWeight(Map context, Searcher searcher) throws IOException {
        for (ValueSource source : this.sources) {
            source.createWeight(context, searcher);
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.sources) + this.name().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        MultiFloatFunction other = (MultiFloatFunction)o;
        return this.name().equals(other.name()) && Arrays.equals(this.sources, other.sources);
    }
}

