/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.NamedParser;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.SingleFunction;
import org.apache.solr.search.function.ValueSource;

abstract class DoubleParser
extends NamedParser {
    public DoubleParser(String name) {
        super(name);
    }

    public abstract double func(int var1, DocValues var2);

    @Override
    public ValueSource parse(FunctionQParser fp) throws ParseException {
        return new Function(fp.parseValueSource());
    }

    class Function
    extends SingleFunction {
        public Function(ValueSource source) {
            super(source);
        }

        @Override
        public String name() {
            return DoubleParser.this.name();
        }

        @Override
        public DocValues getValues(Map context, IndexReader reader) throws IOException {
            final DocValues vals = this.source.getValues(context, reader);
            return new DocValues(){

                @Override
                public float floatVal(int doc) {
                    return (float)this.doubleVal(doc);
                }

                @Override
                public int intVal(int doc) {
                    return (int)this.doubleVal(doc);
                }

                @Override
                public long longVal(int doc) {
                    return (long)this.doubleVal(doc);
                }

                @Override
                public double doubleVal(int doc) {
                    return DoubleParser.this.func(doc, vals);
                }

                @Override
                public String strVal(int doc) {
                    return Double.toString(this.doubleVal(doc));
                }

                @Override
                public String toString(int doc) {
                    return Function.this.name() + '(' + vals.toString(doc) + ')';
                }
            };
        }
    }
}

