/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;

public class UUIDField
extends FieldType {
    private static final String NEW = "NEW";
    private static final char DASH = '-';

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        this.restrictProps(2);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeStr(name, f.stringValue());
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        writer.writeStr(name, f.stringValue(), false);
    }

    @Override
    public String toInternal(String val) {
        if (val == null || 0 == val.length() || NEW.equals(val)) {
            return UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH);
        }
        if (val.length() != 36 || val.charAt(8) != '-' || val.charAt(13) != '-' || val.charAt(18) != '-' || val.charAt(23) != '-') {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid UUID String: '" + val + "'");
        }
        return val.toLowerCase(Locale.ENGLISH);
    }

    public String toInternal(UUID uuid) {
        return uuid.toString().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public UUID toObject(Fieldable f) {
        return UUID.fromString(f.stringValue());
    }
}

