/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;
import org.apache.solr.search.function.StringIndexDocValues;
import org.apache.solr.util.NumberUtils;

class SortableFloatFieldSource
extends FieldCacheSource {
    protected float defVal;
    private static int hcode = SortableFloatFieldSource.class.hashCode();

    public SortableFloatFieldSource(String field) {
        this(field, 0.0f);
    }

    public SortableFloatFieldSource(String field, float defVal) {
        super(field);
        this.defVal = defVal;
    }

    @Override
    public String description() {
        return "sfloat(" + this.field + ')';
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final float def = this.defVal;
        return new StringIndexDocValues(this, reader, this.field){

            @Override
            protected String toTerm(String readableValue) {
                return NumberUtils.float2sortableStr(readableValue);
            }

            @Override
            public float floatVal(int doc) {
                int ord = this.order[doc];
                return ord == 0 ? def : NumberUtils.SortableStr2float(this.lookup[ord]);
            }

            @Override
            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            @Override
            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            @Override
            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            @Override
            public String toString(int doc) {
                return SortableFloatFieldSource.this.description() + '=' + this.floatVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof SortableFloatFieldSource && super.equals(o) && this.defVal == ((SortableFloatFieldSource)o).defVal;
    }

    @Override
    public int hashCode() {
        return hcode + super.hashCode() + Float.floatToIntBits(this.defVal);
    }
}

