# -*- coding: utf-8 -*-

import db, log, conf, sys, timeit, random, emailAdapter
from datetime import datetime, timedelta
import os, time
import subprocess

def valida_rotina(rotina):
    cnx = None
    try:
        cf = conf.open_conf()
        log.log_config(int(cf['app']['log_level']),str(rotina['NomeLog']))
        log.log.info('=========== * {} - Iniciando Validacao da Rotina: {} * ==========='.format(os.getpid(),rotina['DescricaoRotina']))
        cnx = db.connect_db(cf['db']['host'], cf['db']['database'], cf['db']['port'], cf['db']['user'],  cf['db']['password'])
        log.log.info('=========== * {} - Validando se a rotina continua rodando: {} *'.format(os.getpid(),rotina['DescricaoRotina']))
        
        if(rotina['PID'] is None or rotina['PID'] == ''):
            db.atualizar_controle_execucao_rotina(cnx,'NOVO',rotina['IDControleExecucaoRotina'])
            log.log.info('=========== * Passando rotina para o Status NOVO - 1')
        else:
            resultado = ''
            resultado = os.popen('cat /proc/{}/cmdline'.format(rotina['PID'])).read().replace('\x00','')
            log.log.info('=========== * cat /proc/{}/cmdline'.format(rotina['PID']))
            log.log.info('=========== * {}'.format(resultado))
            if resultado == '':
                log.log.info('=========== * Passando rotina para o Status NOVO - 2')
                db.atualizar_controle_execucao_rotina(cnx,'NOVO',rotina['IDControleExecucaoRotina'])
            else:
                log.log.info('=========== * {} '.format(str(rotina['ComandoRotina']).format(rotina['IDControleExecucaoRotina']).replace(' ','')))
                comando = str(rotina['ComandoRotina']).format(rotina['IDControleExecucaoRotina']).replace(' ','')
                log.log.info('=========== * {} '.format(comando))
                log.log.info('=========== * Validando se a rotina está rodando  : {} '.format(resultado not in comando))
                if(int(comando.find(resultado)) == -1):
                    log.log.info('=========== * Passando rotina para o Status NOVO - 3')
                    db.atualizar_controle_execucao_rotina(cnx,'NOVO',rotina['IDControleExecucaoRotina'])
                else:
                    log.log.info('=========== * Rotina ainda está rodando...')
                    
    except Exception as error:
        log.log.error('Falha ao tentar validar as rotinas: %s' % error)
    finally:
        if cnx != None:
            cnx.close()
    log.log.info('=========== * {} - Finalizando Validacao da Rotina: {} * ==========='.format(os.getpid(),rotina['DescricaoRotina']))
