# -*- coding: utf-8 -*-

import db, log, conf, sys, timeit, random, emailAdapter
from datetime import datetime, timedelta
import os, time
import subprocess

def stop_rotina(rotina):
    cnx = None
    try:
        cf = conf.open_conf()
        log.log_config(int(cf['app']['log_level']),str(rotina['NomeLog']))
        log.log.info('=========== * {} - Iniciando aborto da rotina: {} * ==========='.format(os.getpid(),rotina['Rotina']['DescricaoRotina']))
        cnx = db.connect_db(cf['db']['host'], cf['db']['database'], cf['db']['port'], cf['db']['user'],  cf['db']['password'])
        db.atualizar_controle_execucao_finalizado(cnx,'ABORTADO',rotina['Rotina']['IDControleExecucaoRotina'],datetime.now())
        os.system('{} {}'.format(cf['app']['comando_stop_rotinas'],rotina['Rotina']['PID']))
        modelo = db.busca_modelo_email(cnx,cf['db']['database_comercial'],cf['app']['id_modelo_erro_email'])
        log.log.info('=========== * {} - Enviando email informado que foi abortado: {} * ==========='.format(os.getpid(),rotina['Rotina']['DescricaoRotina']))
        envia_email_erro(cf,modelo,rotina['Rotina']['NomeUsuario'],rotina['Rotina']['NomeArquivo'],rotina['Rotina']['EmailUsuario'])
        cnx.close()
    except Exception as error:
        log.log.error('Falha ao tentar parar as rotinas: %s' % error)
    finally:
        if cnx != None:
            cnx.close()
    log.log.info('=========== * {} - Finalizando aborto da Rotina: {} * ==========='.format(os.getpid(),rotina['Rotina']['DescricaoRotina']))

def envia_email_erro(cf, modelo, nomeUsuario, nomeArquivo, emailExtra):
    mensagem = str(modelo[0]['Mensagem'])
    mensagem = mensagem.replace('$nome_usuario$',nomeUsuario)
    mensagem = mensagem.replace('$nome_arquivo$',nomeArquivo)
    emailAdapter.send_email(cf,"Erro ao executar impressão massa - ABORTADO", mensagem, emailExtra)
