# -*- coding: utf-8 -*-

import smtplib
from socket import gaierror
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart

def send_email(cf,assunto = "Assunto", mensagem="Mensagem", emailExtra="desenvolvimento@adaptersolucoes.com"):
    
    port = cf['email_adapter']['porta_SMTP']
    smtp_server = cf['email_adapter']['host_SMTP']
    login = cf['email_adapter']['login_email']
    password = cf['email_adapter']['senha_email']

    sender_email = cf['email_adapter']['remetente_email']
    receiver_email = cf['email_adapter']['destinatario']

    message = MIMEMultipart("alternative")
    message["Subject"] = assunto
    message["From"] = sender_email
    message["To"] = "{};{}".format(receiver_email,emailExtra)
    # write the plain text part
    
    # convert both parts to MIMEText objects and add them to the MIMEMultipart message
    message.attach(MIMEText(mensagem, "html"))

    try:
        #send your message with credentials specified above
        server = smtplib.SMTP(str(smtp_server), int(port))
        server.login(login, password)
        server.sendmail(sender_email, receiver_email, message.as_string())
        server.close()
        # tell the script to report if your message was sent or which errors need to be fixed 
        print('Sent')
    except (gaierror):
        print('Failed to connect to the server. Bad connection settings?')
    except smtplib.SMTPServerDisconnected:
        print('Failed to connect to the server. Wrong user/password?')
    except smtplib.SMTPException as e:
        print('SMTP error occurred: ' + str(e))
