# -*- coding: utf-8 -*-

import log
import mysql.connector as myc


def connect_db(host='localhost', database='information_schema', port=3306, user='root', password=''):
    try:
        log.log.info('- Abrindo conexão com o host "%s", porta "%s" e banco de dados "%s"' % (str(host), str(port), str(database)))
        return myc.connect(host=host, database=database, port=int(port), user=user, password=password, charset='utf8', use_unicode=True)
    except Exception as e:
        log.log.error('Falha ao conectar no banco de dados: %s' % e)


def busca_rotinas_a_rodar(cnx, idServidorIntegracao):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("""
            SELECT
                controle.IDControleExecucaoRotina,
                MIN(controle.DataCadastro) AS DataCadastro,
                rotina.IDRotina,
                rotina.DescricaoRotina,
                rotina.ComandoRotina
            FROM
                TB_ControleExecucaoRotina controle
                INNER JOIN TB_Rotina rotina ON controle.IDRotina = rotina.IDRotina
            WHERE
                controle.`Status` = 'NOVO' AND  rotina.IDServidorIntegracao IN ({})
                #AND rotina.UtilizaControle = 1
            GROUP BY
                controle.IDRotina
        """.format(idServidorIntegracao))
        return cur.fetchall()
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)

def busca_rotinas_a_abortar(cnx, gateway, idServidorIntegracao,tempoExtra):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("""
            SELECT
                controle.IDControleExecucaoRotina,
                controle.PID,
                controle.NomeArquivo,
                rotina.IDRotina,
                rotina.DescricaoRotina,
                usuario.EmailUsuario,
                usuario.NomeUsuario
            FROM
                TB_ControleExecucaoRotina controle
            INNER JOIN TB_Rotina rotina ON controle.IDRotina = rotina.IDRotina
            INNER JOIN {}.TB_Usuario usuario ON controle.IDUsuario = usuario.IDUsuario
            WHERE
                controle.PID IS NOT NULL AND controle.`Status` = 'EM_EXECUCAO' AND
                rotina.IDServidorIntegracao IN ({}) AND
                DATE_ADD(controle.DataInicio, INTERVAL (rotina.LimiteExecucao+{}) MINUTE) < NOW()
        """.format(gateway,idServidorIntegracao,tempoExtra))
        return cur.fetchall()
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)

def pode_rodar_rotina(cnx, idRotina):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("""
            SELECT
                controle.IDControleExecucaoRotina
            FROM
                TB_ControleExecucaoRotina controle
            WHERE
                controle.`Status` IN ('AGUARDANDO','EM_EXECUCAO') AND controle.IDRotina = {}
            LIMIT 1
        """.format(idRotina))
        return cur.fetchall()
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)

def busca_rotinas_a_abortar(cnx, gateway, idServidorIntegracao,tempoExtra):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("""
            SELECT
                controle.IDControleExecucaoRotina,
                controle.PID,
                controle.NomeArquivo,
                rotina.IDRotina,
                rotina.DescricaoRotina,
                usuario.EmailUsuario,
                usuario.NomeUsuario
            FROM
                TB_ControleExecucaoRotina controle
            INNER JOIN TB_Rotina rotina ON controle.IDRotina = rotina.IDRotina
            INNER JOIN {}.TB_Usuario usuario ON controle.IDUsuario = usuario.IDUsuario
            WHERE
                controle.PID IS NOT NULL AND controle.`Status` = 'EM_EXECUCAO' AND
                rotina.IDServidorIntegracao IN ({}) AND
                DATE_ADD(controle.DataInicio, INTERVAL (rotina.LimiteExecucao+{}) MINUTE) < NOW()
        """.format(gateway,idServidorIntegracao,tempoExtra))
        return cur.fetchall()
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)

def busca_rotinas_para_validar(cnx, idServidorIntegracao):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("""
            SELECT
                controle.IDControleExecucaoRotina,
                rotina.IDRotina,
                rotina.ComandoRotina,
                controle.PID,
	            rotina.DescricaoRotina,
                CONCAT("Log_ValidaRotina-",controle.IDRotina,".log") AS NomeLog
            FROM
                TB_ControleExecucaoRotina controle
            INNER JOIN TB_Rotina rotina ON controle.IDRotina = rotina.IDRotina
            WHERE
                controle.`Status` = "EM_EXECUCAO"
            AND rotina.IDServidorIntegracao IN ({})
            AND rotina.UtilizaControle = 1
            GROUP BY
                controle.IDRotina
        """.format(idServidorIntegracao))
        return cur.fetchall()
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)

def atualizar_controle_execucao_rotina(cnx,status,idControleExecucaoRotina):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute('UPDATE TB_ControleExecucaoRotina SET `Status` = "{}" WHERE IDControleExecucaoRotina = {}'.format(status, idControleExecucaoRotina))
        cnx.commit()
        return True
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)
        return False

def atualizar_controle_execucao_finalizado(cnx,status,idControleExecucaoRotina,dataFim):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute('UPDATE TB_ControleExecucaoRotina SET `Status` = "{}", dataFim = "{}" WHERE IDControleExecucaoRotina = {}'.format(status, dataFim, idControleExecucaoRotina))
        cnx.commit()
        return True
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)
        return False

def busca_modelo_email(cnx, comercial, idModeloEmail):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("""
            SELECT
                modelo.Mensagem
            FROM
                {}.TB_ModeloEmail modelo
            WHERE
                modelo.IDModeloEmail = {}
        """.format(comercial,idModeloEmail))
        return cur.fetchall()
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)
