# -*- coding: utf-8 -*-

import db, log, conf, sys, timeit, random
from datetime import datetime, timedelta
import multiprocessing, os, time 
import startrotina, stoprotina, validarotina
from multiprocessing import Pool, TimeoutError

def obtem_numero_process_pool(numero_rotinas):
    if numero_rotinas <= multiprocessing.cpu_count():
        if numero_rotinas <= 1:
            return int(numero_rotinas)
        else:
            if multiprocessing.cpu_count() > numero_rotinas:
                return int(int(multiprocessing.cpu_count())/int(numero_rotinas))
            else:
                return int(multiprocessing.cpu_count())
    else:
        return int(multiprocessing.cpu_count())

def cria_dict_rotina(rotinas):
    retorno = []
    for rotina in rotinas:
        valor = {}
        valor['Rotina'] = rotina
        valor['NomeLog'] = 'start_rotina_process_{}.log'.format(rotina['IDRotina'])
        retorno.append(valor)
    return retorno

def cria_dict_rotina_stop(rotinas):
    retorno = []
    for rotina in rotinas:
        valor = {}
        valor['Rotina'] = rotina
        valor['NomeLog'] = 'stop_rotina_process_{}.log'.format(rotina['IDRotina'])
        retorno.append(valor)
    return retorno

def start_rotina(cf, time_sleep, lock):
    start_time = timeit.default_timer()
    cnx = None
    log.log_config(int(cf['app']['log_level']),'Log_start_rotina.log')
    try:
        log.log.info('=========== * Iniciando Processo de iniciar rotinas de PID: {} * ==========='.format(os.getpid()))
        cnx = db.connect_db(cf['db']['host'], cf['db']['database'], cf['db']['port'], cf['db']['user'], cf['db']['password'])
         
        log.log.info('=========== * Busca de rotinas do IdServidorIntegracao: {}.'.format(cf['app']['id_servidor_rotinas']))
        rotinas = db.busca_rotinas_a_rodar(cnx,cf['app']['id_servidor_rotinas'])
        if rotinas != None and len(rotinas) > 0:
            log.log.info('=========== * Quantidade de rotinas encontradas: {}.'.format(len(rotinas)))
            cnx.close()
            log.log.info('=========== * Fechando conexao com o banco de dados.')
            log.log.info('=========== * Tamanho da Pool: {} e numero de CPU: {}.'.format(obtem_numero_process_pool(len(rotinas)),multiprocessing.cpu_count()))
            pool = Pool(processes=obtem_numero_process_pool(len(rotinas)))
            log.log.info('=========== * Criando processos para Iniciar a Rotina.')
            valores = cria_dict_rotina(rotinas)
            pool.map_async(startrotina.start_rotina,valores)
            pool.close()
            pool.join()
            log.log.info('=========== * Finalizando processos de iniciar as rotinas.')
        else:
            log.log.info('=========== * Nao foi encontrado nenhuma rotina para iniciar.')
    except Exception as error:
        log.log.error('Falha ao tentar iniciar as rotinas: %s' % error)
    finally:
        if cnx != None:
            cnx.close()
            log.log.info('=========== * Fechando conexao com o banco de dados.')
    elapsed = timeit.default_timer() - start_time
    lock.acquire()
    time_sleep.value = time_sleep.value + int(elapsed)
    lock.release()
    log.log.info('=========== * Tempo gasto para finalizar processo: %s. * ===========' % elapsed)
    log.log.info('=========== * Finalizado Processo de iniciar rotinas de PID: {} * ==========='.format(os.getpid()))
    
def stop_rotina(cf, time_sleep, lock): 
    start_time = timeit.default_timer()
    cnx = None
    log.log_config(int(cf['app']['log_level']),'Log_stop_rotina.log')
    try:
        log.log.info('=========== * Iniciando Processo de PID: {}. Para parar rotinas * ==========='.format(os.getpid()))
        cnx = db.connect_db(cf['db']['host'], cf['db']['database'], cf['db']['port'], cf['db']['user'], cf['db']['password'])

        log.log.info('=========== * Busca de rotinas para parar do IdServidorIntegracao: {}.'.format(cf['app']['id_servidor_rotinas']))
        rotinas = db.busca_rotinas_a_abortar(cnx,cf['db']['database_gateway'],cf['app']['id_servidor_rotinas'],cf['app']['tempo_extra_stop_rotinas'])
        if rotinas != None and len(rotinas) > 0:
            log.log.info('=========== * Quantidade de rotinas encontradas: {}.'.format(len(rotinas)))
            cnx.close()
            log.log.info('=========== * Fechando conexao com o banco de dados.')
            log.log.info('=========== * Tamanho da Pool: {} e numero de CPU: {}.'.format(obtem_numero_process_pool(len(rotinas)),multiprocessing.cpu_count()))
            pool = Pool(processes=obtem_numero_process_pool(len(rotinas)))
            log.log.info('=========== * Criando processos para parar a Rotina.')
            valores = cria_dict_rotina_stop(rotinas)
            pool.map_async(stoprotina.stop_rotina,valores)
            pool.close()
            pool.join()
            log.log.info('=========== * Finalizando processos de parar as rotinas.')
        else:
            log.log.info('=========== * Nao foi encontrado nenhuma rotina para parar.')
    except Exception as error:
        log.log.error('Falha ao tentar parar as rotinas: %s' % error)
    finally:
        if cnx != None:
            cnx.close()
            log.log.info('=========== * Fechando conexao com o banco de dados.')
    
    elapsed = timeit.default_timer() - start_time
    lock.acquire()
    time_sleep.value = time_sleep.value + int(elapsed)
    lock.release()
    log.log.info('=========== * Tempo gasto para finalizar processo: %s. * ===========' % elapsed)
    log.log.info('=========== * Finalizado Processo PID: {}. Para parar rotinas* ==========='.format(os.getpid()))

def valida_rotina(cf,time_sleep, lock):
    start_time = timeit.default_timer()
    cnx = None
    log.log_config(int(cf['app']['log_level']),'Log_valida_rotina.log')
    try:
        log.log.info('=========== * Iniciando Processo de PID: {}. Para Validar rotinas * ==========='.format(os.getpid()))
        cnx = db.connect_db(cf['db']['host'], cf['db']['database'], cf['db']['port'], cf['db']['user'], cf['db']['password'])

        log.log.info('=========== * Busca de rotinas para Validar do IdServidorIntegracao: {}.'.format(cf['app']['id_servidor_rotinas']))
        rotinas = db.busca_rotinas_para_validar(cnx,cf['app']['id_servidor_rotinas'])
        if rotinas != None and len(rotinas) > 0:
            log.log.info('=========== * Quantidade de rotinas encontradas: {}.'.format(len(rotinas)))
            cnx.close()
            log.log.info('=========== * Fechando conexao com o banco de dados.')
            log.log.info('=========== * Tamanho da Pool: {} e numero de CPU: {}.'.format(obtem_numero_process_pool(len(rotinas)),multiprocessing.cpu_count()))
            #pool = Pool(processes=obtem_numero_process_pool(len(rotinas)))
            log.log.info('=========== * Criando processos para Validar a Rotina.')
            for rotina in rotinas:
                validarotina.valida_rotina(rotina)
            #pool.map_async(validarotina.valida_rotina,rotinas)
            #pool.close()
            #pool.join()
            log.log.info('=========== * Finalizando processos de parar as rotinas.')
        else:
            log.log.info('=========== * Nao foi encontrado nenhuma rotina para Validar.')
    except Exception as error:
        log.log.error('Falha ao tentar validar as rotinas: %s' % error)
    finally:
        if cnx != None:
            cnx.close()
            log.log.info('=========== * Fechando conexao com o banco de dados.')
    
    elapsed = timeit.default_timer() - start_time
    lock.acquire()
    #time_sleep.value = time_sleep.value + int(elapsed)
    time_sleep.value = 0
    lock.release()
    log.log.info('=========== * Tempo gasto para finalizar processo: %s. * ===========' % elapsed)
    log.log.info('=========== * Finalizado Processo PID: {}. Para Validar rotinas* ==========='.format(os.getpid()))

def main():
    start_time = timeit.default_timer()
    cf = conf.open_conf()
    log.log_config(int(cf['app']['log_level']))
    log.log.info('=========== * Iniciando Servico Controle Execucao Rotina * ===========')
    while True:
        time_sleep_start = multiprocessing.Value('i',0)
        time_sleep_stop = multiprocessing.Value('i',0)
        time_sleep_valida = multiprocessing.Value('i',0)
        lock = multiprocessing.Lock()
        
        log.log.info('=========== * Processo main com PID: {} * ==========='.format(os.getpid()))

        # creating processes 
        p1 = multiprocessing.Process(target=start_rotina, args=(cf, time_sleep_start, lock)) 
        p2 = multiprocessing.Process(target=stop_rotina, args=(cf, time_sleep_stop, lock)) 
        p3 = multiprocessing.Process(target=valida_rotina, args=(cf, time_sleep_valida, lock)) 

        # starting processes 
        p1.start() 
        p2.start()
        p3.start()
        # wait until processes are finished 
        p1.join() 
        p2.join()
        p3.join()

        log.log.info('=========== * Processos finalizados * ===========')
        log.log.info('=========== * Tempo gasto dos Serviços: {} * ==========='.format((time_sleep_start.value+time_sleep_stop.value)))
        log.log.info('=========== * Finalizando Servico Controle Execucao Rotina * ===========')
        time.sleep(int(time_sleep_start.value+time_sleep_stop.value+time_sleep_valida.value)+30)
    sys.exit(0)


if __name__ == '__main__':
    main()
