/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.apt.dispatch.AnnotationDiscoveryVisitor;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.apt.util.ManyToMany;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;

public class RoundEnvImpl
implements RoundEnvironment {
    private final BaseProcessingEnvImpl _processingEnv;
    private final boolean _isLastRound;
    private final CompilationUnitDeclaration[] _units;
    private final ManyToMany<TypeElement, Element> _annoToUnit;
    private final ReferenceBinding[] _binaryTypes;
    private final Factory _factory;
    private Set<Element> _rootElements = null;

    public RoundEnvImpl(CompilationUnitDeclaration[] units, ReferenceBinding[] binaryTypeBindings, boolean isLastRound, BaseProcessingEnvImpl env) {
        this._processingEnv = env;
        this._isLastRound = isLastRound;
        this._units = units;
        this._factory = this._processingEnv.getFactory();
        AnnotationDiscoveryVisitor visitor = new AnnotationDiscoveryVisitor(this._processingEnv);
        if (this._units != null) {
            for (CompilationUnitDeclaration unit : this._units) {
                unit.scope.suppressImportErrors = true;
                unit.traverse((ASTVisitor)visitor, unit.scope);
                unit.scope.suppressImportErrors = false;
            }
        }
        this._annoToUnit = visitor._annoToElement;
        if (binaryTypeBindings != null) {
            this.collectAnnotations(binaryTypeBindings);
        }
        this._binaryTypes = binaryTypeBindings;
    }

    private void collectAnnotations(ReferenceBinding[] referenceBindings) {
        for (ReferenceBinding referenceBinding : referenceBindings) {
            MethodBinding[] methodBindings;
            FieldBinding[] fieldBindings;
            AnnotationBinding[] annotationBindings;
            if (referenceBinding instanceof ParameterizedTypeBinding) {
                referenceBinding = ((ParameterizedTypeBinding)referenceBinding).genericType();
            }
            for (AnnotationBinding annotationBinding : annotationBindings = Factory.getPackedAnnotationBindings(referenceBinding.getAnnotations())) {
                TypeElement anno = (TypeElement)this._factory.newElement(annotationBinding.getAnnotationType());
                Element element = this._factory.newElement(referenceBinding);
                this._annoToUnit.put(anno, element);
            }
            for (FieldBinding fieldBinding : fieldBindings = referenceBinding.fields()) {
                for (AnnotationBinding annotationBinding : annotationBindings = Factory.getPackedAnnotationBindings(fieldBinding.getAnnotations())) {
                    TypeElement anno = (TypeElement)this._factory.newElement(annotationBinding.getAnnotationType());
                    Element element = this._factory.newElement(fieldBinding);
                    this._annoToUnit.put(anno, element);
                }
            }
            for (MethodBinding methodBinding : methodBindings = referenceBinding.methods()) {
                for (AnnotationBinding annotationBinding : annotationBindings = Factory.getPackedAnnotationBindings(methodBinding.getAnnotations())) {
                    TypeElement anno = (TypeElement)this._factory.newElement(annotationBinding.getAnnotationType());
                    Element element = this._factory.newElement(methodBinding);
                    this._annoToUnit.put(anno, element);
                }
            }
            ReferenceBinding[] memberTypes = referenceBinding.memberTypes();
            this.collectAnnotations(memberTypes);
        }
    }

    public Set<TypeElement> getRootAnnotations() {
        return Collections.unmodifiableSet(this._annoToUnit.getKeySet());
    }

    @Override
    public boolean errorRaised() {
        return this._processingEnv.errorRaised();
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(TypeElement a) {
        if (a.getKind() != ElementKind.ANNOTATION_TYPE) {
            throw new IllegalArgumentException("Argument must represent an annotation type");
        }
        Binding annoBinding = ((TypeElementImpl)a)._binding;
        if (0L != (annoBinding.getAnnotationTagBits() & 0x1000000000000L)) {
            HashSet<Element> annotatedElements = new HashSet<Element>(this._annoToUnit.getValues(a));
            ReferenceBinding annoTypeBinding = (ReferenceBinding)annoBinding;
            for (TypeElement element : ElementFilter.typesIn(this.getRootElements())) {
                ReferenceBinding typeBinding = (ReferenceBinding)((TypeElementImpl)element)._binding;
                this.addAnnotatedElements(annoTypeBinding, typeBinding, annotatedElements);
            }
            return Collections.unmodifiableSet(annotatedElements);
        }
        return Collections.unmodifiableSet(this._annoToUnit.getValues(a));
    }

    private void addAnnotatedElements(ReferenceBinding anno, ReferenceBinding type, Set<Element> result) {
        if (type.isClass() && this.inheritsAnno(type, anno)) {
            result.add(this._factory.newElement(type));
        }
        for (ReferenceBinding element : type.memberTypes()) {
            this.addAnnotatedElements(anno, element, result);
        }
    }

    private boolean inheritsAnno(ReferenceBinding element, ReferenceBinding anno) {
        ReferenceBinding searchedElement = element;
        do {
            AnnotationBinding[] annos;
            if (searchedElement instanceof ParameterizedTypeBinding) {
                searchedElement = ((ParameterizedTypeBinding)searchedElement).genericType();
            }
            for (AnnotationBinding annoBinding : annos = Factory.getPackedAnnotationBindings(searchedElement.getAnnotations())) {
                if (annoBinding.getAnnotationType() != anno) continue;
                return true;
            }
        } while (null != (searchedElement = searchedElement.superclass()));
        return false;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(Class<? extends Annotation> a) {
        String canonicalName = a.getCanonicalName();
        if (canonicalName == null) {
            throw new IllegalArgumentException("Argument must represent an annotation type");
        }
        TypeElement annoType = this._processingEnv.getElementUtils().getTypeElement(canonicalName);
        return this.getElementsAnnotatedWith(annoType);
    }

    @Override
    public Set<? extends Element> getRootElements() {
        if (this._units == null) {
            return Collections.emptySet();
        }
        if (this._rootElements == null) {
            HashSet<Element> elements = new HashSet<Element>(this._units.length);
            for (CompilationUnitDeclaration unit : this._units) {
                if (null == unit.scope || null == unit.scope.topLevelTypes) continue;
                for (SourceTypeBinding binding : unit.scope.topLevelTypes) {
                    Element element = this._factory.newElement(binding);
                    if (null == element) {
                        throw new IllegalArgumentException("Top-level type binding could not be converted to element: " + binding);
                    }
                    elements.add(element);
                }
            }
            if (this._binaryTypes != null) {
                for (ReferenceBinding typeBinding : this._binaryTypes) {
                    Element element = this._factory.newElement(typeBinding);
                    if (null == element) {
                        throw new IllegalArgumentException("Top-level type binding could not be converted to element: " + typeBinding);
                    }
                    elements.add(element);
                }
            }
            this._rootElements = elements;
        }
        return this._rootElements;
    }

    @Override
    public boolean processingOver() {
        return this._isLastRound;
    }
}

