/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.sso;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.authenticator.Constants;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.jboss.as.clustering.web.sso.FullyQualifiedSessionId;
import org.jboss.as.clustering.web.sso.SSOClusterManager;
import org.jboss.as.clustering.web.sso.SSOCredentials;
import org.jboss.as.clustering.web.sso.SSOLocalManager;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.session.ClusteredSession;
import org.jboss.as.web.session.notification.ClusteredSessionNotificationCause;
import org.jboss.as.web.sso.SingleSignOnEntry;

public class ClusteredSingleSignOn
extends SingleSignOn
implements LifecycleListener,
SSOLocalManager {
    public static final int DEFAULT_PROCESS_EXPIRES_INTERVAL = 60;
    public static final int DEFAULT_MAX_EMPTY_LIFE = 1800;
    private final SSOClusterManager ssoClusterManager;
    private Set<Manager> activeManagers = new CopyOnWriteArraySet<Manager>();
    private volatile int maxEmptyLife = 1800000;
    private volatile int processExpiresInterval = 60000;
    private volatile long lastProcessExpires = System.currentTimeMillis();
    private Map<String, Long> emptySSOs = new ConcurrentHashMap<String, Long>();
    private final Object MUTEX = new Object();

    public ClusteredSingleSignOn(SSOClusterManager ssoClusterManager) {
        this.ssoClusterManager = ssoClusterManager;
        this.ssoClusterManager.setSSOLocalManager((SSOLocalManager)this);
    }

    public int getMaxEmptyLife() {
        return this.maxEmptyLife / 1000;
    }

    public void setMaxEmptyLife(int maxEmptyLife) {
        this.maxEmptyLife = maxEmptyLife * 1000;
    }

    public int getProcessExpiresInterval() {
        return this.processExpiresInterval / 1000;
    }

    public void setProcessExpiresInterval(int processExpiresInterval) {
        this.processExpiresInterval = processExpiresInterval * 1000;
    }

    public long getLastProcessExpires() {
        return this.lastProcessExpires;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(WebMessages.MESSAGES.valveAlreadyStarted());
        }
        this.checkSystemProperties();
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(WebMessages.MESSAGES.valveNotStarted());
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEvent(SessionEvent event) {
        WebLogger.WEB_SSO_LOGGER.tracef("received SessionEvent %s", event.toString());
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        WebLogger.WEB_SSO_LOGGER.tracef("Process session destroyed on %s", session);
        String ssoId = null;
        Map map = this.reverse;
        synchronized (map) {
            ssoId = (String)this.reverse.get(session);
        }
        if (ssoId == null) {
            WebLogger.WEB_SSO_LOGGER.tracef("ignoring as SSO is already closed for session %s", session);
            return;
        }
        boolean stopped = false;
        boolean timedOut = this.isSessionTimedOut(session);
        if (timedOut || (stopped = this.isManagerStopped(session))) {
            WebLogger.WEB_SSO_LOGGER.tracef("remove session %s from SSO %s, isSessionTimedOut=%s, isManagerStopped=%s", new Object[]{session, ssoId, timedOut, stopped});
            this.removeSession(ssoId, session);
            this.processExpires();
        } else {
            WebLogger.WEB_SSO_LOGGER.tracef("user logged out of SSO %s", ssoId);
            this.logout(ssoId);
        }
    }

    private boolean isSessionTimedOut(Session session) {
        return session.getMaxInactiveInterval() > 0 && System.currentTimeMillis() - session.getLastAccessedTime() >= (long)(session.getMaxInactiveInterval() * 1000);
    }

    private boolean isManagerStopped(Session session) {
        return !this.activeManagers.contains(session.getManager());
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source;
        boolean removed;
        String type = event.getType();
        if (("before_stop".equals(type) || "stop".equals(type) || "after_stop".equals(type)) && (removed = this.activeManagers.remove(source = event.getLifecycle()))) {
            source.removeLifecycleListener((LifecycleListener)this);
            WebLogger.WEB_SSO_LOGGER.tracef("ClusteredSSO: removed stopped manager %s", source);
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        WebLogger.WEB_SSO_LOGGER.tracef("handling request %s", request.getRequestURI());
        request.removeNote("org.apache.catalina.request.SSOID");
        WebLogger.WEB_SSO_LOGGER.tracef("Process request for '%s'", request.getRequestURI());
        if (request.getUserPrincipal() != null) {
            WebLogger.WEB_SSO_LOGGER.tracef("Principal '%s' has already been authenticated", request.getUserPrincipal().getName());
            this.getNext().invoke(request, response);
            return;
        }
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!Constants.SINGLE_SIGN_ON_COOKIE.equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            WebLogger.WEB_SSO_LOGGER.trace("SSO cookie is not present");
            this.getNext().invoke(request, response);
            return;
        }
        String ssoId = cookie.getValue();
        WebLogger.WEB_SSO_LOGGER.tracef("Checking for cached principal for %s", ssoId);
        SingleSignOnEntry entry = this.getSingleSignOnEntry(cookie.getValue());
        if (entry != null && this.isValid(ssoId, entry)) {
            Principal ssoPrinc = entry.getPrincipal();
            WebLogger.WEB_SSO_LOGGER.tracef("Found cached principal '%s' with auth type '%s'", ssoPrinc == null ? "NULL" : ssoPrinc.getName(), entry.getAuthType());
            request.setNote("org.apache.catalina.request.SSOID", (Object)cookie.getValue());
            if (!this.getRequireReauthentication() && ssoPrinc != null) {
                request.setAuthType(entry.getAuthType());
                request.setUserPrincipal(ssoPrinc);
            }
        } else {
            WebLogger.WEB_SSO_LOGGER.tracef("No cached principal found, erasing SSO cookie", new Object[0]);
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
        this.getNext().invoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associate(String ssoId, Session session) {
        WebLogger.WEB_SSO_LOGGER.tracef("Associate sso id %s with session %s", ssoId, session);
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        boolean added = false;
        if (sso != null) {
            added = sso.addSession2(this, session);
        }
        Map map = this.reverse;
        synchronized (map) {
            this.reverse.put(session, ssoId);
        }
        if (added) {
            Manager manager = session.getManager();
            if (this.activeManagers.add(manager)) {
                ((Lifecycle)manager).addLifecycleListener((LifecycleListener)this);
            }
            if (this.ssoClusterManager != null) {
                this.ssoClusterManager.addSession(ssoId, this.getFullyQualifiedSessionId(session));
                this.notifySSONotEmpty(ssoId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId, Session session) {
        Map map = this.reverse;
        synchronized (map) {
            this.reverse.remove(session);
        }
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        if (sso == null) {
            return;
        }
        boolean removed = sso.removeSession2(session);
        if (this.ssoClusterManager != null) {
            if (removed) {
                this.ssoClusterManager.removeSession(ssoId, this.getFullyQualifiedSessionId(session));
                WebLogger.WEB_SSO_LOGGER.tracef("deregister will notify cluster of removed session %s sso id %s", session, ssoId);
            } else {
                WebLogger.WEB_SSO_LOGGER.tracef("deregister didn't find session %s sso id %s cluster notification not sent", session, ssoId);
            }
        }
        if (sso.getSessionCount() == 0) {
            WebLogger.WEB_SSO_LOGGER.tracef("deregister detected zero sessions for sso id %s", ssoId);
            Map map2 = this.cache;
            synchronized (map2) {
                sso = (SingleSignOnEntry)((Object)this.cache.remove(ssoId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String ssoId) {
        WebLogger.WEB_SSO_LOGGER.tracef("Deregistering sso id '%s'", ssoId);
        this.emptySSOs.remove(ssoId);
        SingleSignOnEntry sso = null;
        Map map = this.cache;
        synchronized (map) {
            sso = (SingleSignOnEntry)((Object)this.cache.remove(ssoId));
        }
        if (sso == null) {
            return;
        }
        for (Session session : sso.findSessions()) {
            WebLogger.WEB_SSO_LOGGER.tracef(" Invalidating session %s", session);
            Map map2 = this.reverse;
            synchronized (map2) {
                this.reverse.remove(session);
            }
            ClassLoader oldContextClassLoader = null;
            try {
                oldContextClassLoader = this.bindThread(session);
                session.expire();
            }
            finally {
                if (oldContextClassLoader != null) {
                    this.unbindThread(session, oldContextClassLoader);
                }
            }
        }
        if (this.ssoClusterManager != null) {
            this.ssoClusterManager.logout(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterLocal(String ssoId) {
        WebLogger.WEB_SSO_LOGGER.tracef("Deregistering locally sso id '%s'", ssoId);
        this.emptySSOs.remove(ssoId);
        SingleSignOnEntry sso = null;
        Map map = this.cache;
        synchronized (map) {
            sso = (SingleSignOnEntry)((Object)this.cache.remove(ssoId));
        }
        if (sso == null) {
            return;
        }
        for (Session session : sso.findSessions()) {
            WebLogger.WEB_SSO_LOGGER.tracef(" Invalidating session %s", session);
            Map map2 = this.reverse;
            synchronized (map2) {
                this.reverse.remove(session);
            }
            if (session instanceof ClusteredSession) {
                ClusteredSession clusteredSession = (ClusteredSession)session;
                boolean notify = true;
                boolean localCall = false;
                boolean localOnly = true;
                clusteredSession.expire(notify, localCall, localOnly, ClusteredSessionNotificationCause.INVALIDATE);
                continue;
            }
            session.expire();
        }
    }

    protected void logout(String ssoId) {
        this.deregister(ssoId);
        if (this.ssoClusterManager != null) {
            this.ssoClusterManager.logout(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogin(String ssoId) {
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        if (sso == null) {
            return;
        }
        for (Session session : sso.findSessions()) {
            session.setAuthType(null);
            session.setPrincipal(null);
            session.removeNote("org.apache.catalina.session.USERNAME");
            session.removeNote("org.apache.catalina.session.PASSWORD");
        }
        SingleSignOnEntry singleSignOnEntry = sso;
        synchronized (singleSignOnEntry) {
            if (sso.updateCredentials2(null, null, null, null)) {
                this.ssoClusterManager.updateCredentials(ssoId, null, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry getSingleSignOnEntry(String ssoId) {
        SSOCredentials credentials;
        SingleSignOnEntry sso = this.localLookup(ssoId);
        if (sso == null && this.ssoClusterManager != null && (credentials = this.ssoClusterManager.lookup(ssoId)) != null) {
            sso = new SingleSignOnEntry(null, credentials.getAuthType(), credentials.getUsername(), credentials.getPassword());
            Map map = this.cache;
            synchronized (map) {
                this.cache.put(ssoId, sso);
            }
        }
        return sso;
    }

    public boolean reauthenticate(String ssoId, Realm realm, Request request) {
        Principal reauthPrincipal;
        String username;
        if (ssoId == null || realm == null) {
            return false;
        }
        boolean reauthenticated = false;
        SingleSignOnEntry entry = this.getSingleSignOnEntry(ssoId);
        if (entry != null && entry.getCanReauthenticate() && (username = entry.getUsername()) != null && (reauthPrincipal = realm.authenticate(username, entry.getPassword())) != null) {
            reauthenticated = true;
            request.setAuthType(entry.getAuthType());
            request.setUserPrincipal(reauthPrincipal);
            entry.setPrincipal(reauthPrincipal);
        }
        return reauthenticated;
    }

    public void register(String ssoId, Principal principal, String authType, String username, String password) {
        this.registerLocal(ssoId, principal, authType, username, password);
        this.ssoClusterManager.register(ssoId, authType, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(String ssoId, Session session) {
        SingleSignOnEntry entry = this.getSingleSignOnEntry(ssoId);
        WebLogger.WEB_SSO_LOGGER.tracef("Removing session %s from sso id %s, %s", session, ssoId, entry != null ? "found SSO entry" : "SSO entry not found");
        if (entry == null) {
            return;
        }
        boolean removed = entry.removeSession2(session);
        WebLogger.WEB_SSO_LOGGER.tracef("Removing Session %s, session found = %s", session, removed);
        if (removed && !this.isManagerStopped(session)) {
            this.ssoClusterManager.removeSession(ssoId, this.getFullyQualifiedSessionId(session));
        }
        Map map = this.reverse;
        synchronized (map) {
            this.reverse.remove(session);
        }
    }

    public void update(String ssoId, Principal principal, String authType, String username, String password) {
        boolean needToBroadcast = this.updateLocal(ssoId, principal, authType, username, password);
        if (needToBroadcast) {
            this.ssoClusterManager.updateCredentials(ssoId, authType, username, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SingleSignOnEntry localLookup(String ssoId) {
        Map map = this.cache;
        synchronized (map) {
            return (SingleSignOnEntry)((Object)this.cache.get(ssoId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerLocal(String ssoId, Principal principal, String authType, String username, String password) {
        WebLogger.WEB_SSO_LOGGER.tracef("Registering sso id '%s' for user '%s' with auth type '%s'", ssoId, principal.getName(), authType);
        Map map = this.cache;
        synchronized (map) {
            this.cache.put(ssoId, new SingleSignOnEntry(principal, authType, username, password));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateLocal(String ssoId, Principal principal, String authType, String username, String password) {
        boolean shouldBroadcast = false;
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        if (sso != null) {
            if (!sso.getCanReauthenticate()) {
                WebLogger.WEB_SSO_LOGGER.tracef("Update sso id %s to auth type %s", ssoId, authType);
                SingleSignOnEntry singleSignOnEntry = sso;
                synchronized (singleSignOnEntry) {
                    shouldBroadcast = sso.updateCredentials2(principal, authType, username, password);
                }
            }
            if (sso.getPrincipal() == null && principal != null) {
                WebLogger.WEB_SSO_LOGGER.tracef("Update sso id %s with principal %s", ssoId, principal.getName());
                SingleSignOnEntry singleSignOnEntry = sso;
                synchronized (singleSignOnEntry) {
                    sso.setPrincipal(principal);
                }
            }
        }
        return shouldBroadcast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteUpdate(String ssoId, SSOCredentials credentials) {
        SingleSignOnEntry sso = this.localLookup(ssoId);
        if (sso != null) {
            if (credentials.getAuthType() == null && credentials.getUsername() == null && credentials.getPassword() == null) {
                WebLogger.WEB_SSO_LOGGER.tracef("Uppdating local SSO cache and associated sessions after SSO id %s was logged out on other cluster member", ssoId);
                for (Session session : sso.findSessions()) {
                    session.setAuthType(null);
                    session.setPrincipal(null);
                    session.removeNote("org.apache.catalina.session.USERNAME");
                    session.removeNote("org.apache.catalina.session.PASSWORD");
                }
                SingleSignOnEntry singleSignOnEntry = sso;
                synchronized (singleSignOnEntry) {
                    sso.updateCredentials(null, credentials.getAuthType(), credentials.getUsername(), credentials.getPassword());
                }
            }
            if (!sso.getCanReauthenticate()) {
                WebLogger.WEB_SSO_LOGGER.tracef("Update sso id %s to auth type %s", ssoId, credentials.getAuthType());
                SingleSignOnEntry singleSignOnEntry = sso;
                synchronized (singleSignOnEntry) {
                    Principal p = sso.getPrincipal();
                    sso.updateCredentials(p, credentials.getAuthType(), credentials.getUsername(), credentials.getPassword());
                }
            }
        }
    }

    public void notifySSOEmpty(String ssoId) {
        Long obj = this.emptySSOs.put(ssoId, new Long(System.currentTimeMillis()));
        if (obj == null) {
            WebLogger.WEB_SSO_LOGGER.tracef("Notified that SSO %s is empty", ssoId);
        }
    }

    public void notifySSONotEmpty(String ssoId) {
        Long obj = this.emptySSOs.remove(ssoId);
        if (obj != null) {
            WebLogger.WEB_SSO_LOGGER.tracef("Notified that SSO %s is no longer empty", ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpires() {
        long now = 0L;
        Object object = this.MUTEX;
        synchronized (object) {
            now = System.currentTimeMillis();
            if (now - this.lastProcessExpires <= (long)this.processExpiresInterval) {
                return;
            }
            this.lastProcessExpires = now;
        }
        this.clearExpiredSSOs(now);
    }

    private synchronized void clearExpiredSSOs(long now) {
        for (Map.Entry<String, Long> entry : this.emptySSOs.entrySet()) {
            if (now - entry.getValue() <= (long)this.maxEmptyLife) continue;
            String ssoId = entry.getKey();
            WebLogger.WEB_SSO_LOGGER.tracef("Invalidating expired SSO %s", ssoId);
            this.logout(ssoId);
        }
    }

    private boolean isValid(String ssoId, SingleSignOnEntry entry) {
        Long expired;
        boolean valid = true;
        if (entry.getSessionCount() == 0 && (expired = this.emptySSOs.get(ssoId)) != null && System.currentTimeMillis() - expired > (long)this.maxEmptyLife) {
            valid = false;
            WebLogger.WEB_SSO_LOGGER.tracef("Invalidating expired SSO %s", ssoId);
            this.logout(ssoId);
        }
        return valid;
    }

    private FullyQualifiedSessionId getFullyQualifiedSessionId(Session session) {
        String id = session.getIdInternal();
        Container context = session.getManager().getContainer();
        String contextName = context.getName();
        Container host = context.getParent();
        String hostName = host.getName();
        return new FullyQualifiedSessionId(id, contextName, hostName);
    }

    private void checkSystemProperties() {
        final WebLogger logger2 = WebLogger.WEB_SSO_LOGGER;
        Properties properties = System.getProperties();
        final String maxEmptyLifeProperty = properties.getProperty("org.jboss.as.web.sso.ClusteredSingleSignOn.maxEmptyLife");
        final String processExpiredIntervalProperty = properties.getProperty("org.jboss.as.web.sso.ClusteredSingleSignOn.processExpiresInterval");
        if (maxEmptyLifeProperty != null || processExpiredIntervalProperty != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (logger2.isInfoEnabled()) {
                        logger2.infof("Checking system properties for maxEmptyLife and processExpiresInterval override values. This is a one-off fix for Red Hat bug BZ-958572", new Object[0]);
                    }
                    if (maxEmptyLifeProperty != null) {
                        ClusteredSingleSignOn.this.setMaxEmptyLife(Integer.parseInt(maxEmptyLifeProperty));
                        if (logger2.isDebugEnabled()) {
                            logger2.debugf("maxEmptyLife preset as a System property. Changed value to %s", ClusteredSingleSignOn.this.maxEmptyLife);
                        }
                    }
                    if (processExpiredIntervalProperty != null) {
                        ClusteredSingleSignOn.this.setProcessExpiresInterval(Integer.parseInt(processExpiredIntervalProperty));
                        if (logger2.isDebugEnabled()) {
                            logger2.debugf("processExpiredInterval preset as a System property. Changed value to %s", ClusteredSingleSignOn.this.processExpiresInterval);
                        }
                    }
                    return null;
                }
            });
        }
        if (logger2.isTraceEnabled()) {
            logger2.tracef("Cleared adding the System properties within a privileged action.", new Object[0]);
        }
    }

    static {
        info = ClusteredSingleSignOn.class.getName();
    }
}

