/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.apache.coyote.Constants;
import org.apache.coyote.Request;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.Http11AbstractProtocol;
import org.apache.coyote.http11.Http11NioProcessor;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.jsse.NioJSSEImplementation;
import org.apache.tomcat.util.net.jsse.NioJSSESocketChannelFactory;
import org.jboss.web.CoyoteLogger;
import org.jboss.web.NetworkUtils;

public class Http11NioProtocol
extends Http11AbstractProtocol {
    protected NioEndpoint endpoint = new NioEndpoint();
    private Http11ConnectionHandler cHandler = new Http11ConnectionHandler(this);
    protected NioJSSESocketChannelFactory socketFactory = null;

    public Http11NioProtocol() {
        this.setSoLinger(-1);
        this.setSoTimeout(org.apache.coyote.http11.Constants.DEFAULT_CONNECTION_TIMEOUT);
        this.setTcpNoDelay(true);
        this.setKeepAliveTimeout(org.apache.coyote.http11.Constants.DEFAULT_KEEP_ALIVE_TIMEOUT);
    }

    @Override
    public RequestGroupInfo getRequestGroupInfo() {
        return this.cHandler.global;
    }

    @Override
    public void init() throws Exception {
        this.endpoint.setName(this.getName());
        this.endpoint.setHandler(this.cHandler);
        try {
            if (this.isSSLEnabled()) {
                this.sslImplementation = new NioJSSEImplementation();
                this.socketFactory = ((NioJSSEImplementation)this.sslImplementation).getServerSocketChannelFactory();
                this.endpoint.setServerSocketChannelFactory(this.socketFactory);
            }
        }
        catch (Exception ex) {
            CoyoteLogger.HTTP_NIO_LOGGER.errorInitializingSocketFactory(ex);
            throw ex;
        }
        if (this.socketFactory != null) {
            for (String key : this.attributes.keySet()) {
                Object v = this.attributes.get(key);
                this.socketFactory.setAttribute(key, v);
            }
        }
        try {
            this.endpoint.init();
        }
        catch (Exception ex) {
            CoyoteLogger.HTTP_NIO_LOGGER.errorInitializingEndpoint(ex);
            throw ex;
        }
        CoyoteLogger.HTTP_NIO_LOGGER.initHttpConnector(this.getName());
    }

    @Override
    public void start() throws Exception {
        if (org.apache.tomcat.util.Constants.ENABLE_MODELER && this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getJmxName());
                Registry.getRegistry(null, null).registerComponent((Object)this.endpoint, this.tpOname, null);
            }
            catch (Exception e) {
                CoyoteLogger.HTTP_NIO_LOGGER.errorRegisteringPool(e);
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getJmxName());
            Registry.getRegistry(null, null).registerComponent((Object)this.cHandler.global, this.rgOname, null);
        }
        try {
            this.endpoint.start();
        }
        catch (Exception ex) {
            CoyoteLogger.HTTP_NIO_LOGGER.errorStartingEndpoint(ex);
            throw ex;
        }
        CoyoteLogger.HTTP_NIO_LOGGER.startHttpConnector(this.getName());
    }

    @Override
    public void pause() throws Exception {
        try {
            this.endpoint.pause();
        }
        catch (Exception ex) {
            CoyoteLogger.HTTP_NIO_LOGGER.errorPausingEndpoint(ex);
            throw ex;
        }
        this.canDestroy = false;
        RequestInfo[] states = this.cHandler.global.getRequestProcessors();
        int retry = 0;
        boolean done = false;
        while (!done && retry < Constants.MAX_PAUSE_WAIT) {
            ++retry;
            done = true;
            for (int i = 0; i < states.length; ++i) {
                if (states[i].getStage() != 3) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                done = false;
                break;
            }
            if (!done) continue;
            this.canDestroy = true;
        }
        CoyoteLogger.HTTP_NIO_LOGGER.pauseHttpConnector(this.getName());
    }

    @Override
    public void resume() throws Exception {
        try {
            this.endpoint.resume();
        }
        catch (Exception ex) {
            CoyoteLogger.HTTP_NIO_LOGGER.errorResumingEndpoint(ex);
            throw ex;
        }
        CoyoteLogger.HTTP_NIO_LOGGER.resumeHttpConnector(this.getName());
    }

    @Override
    public void destroy() throws Exception {
        CoyoteLogger.HTTP_NIO_LOGGER.stopHttpConnector(this.getName());
        if (this.canDestroy) {
            this.endpoint.destroy();
        } else {
            CoyoteLogger.HTTP_NIO_LOGGER.cannotDestroyHttpProtocol(this.getName());
            try {
                RequestInfo[] states = this.cHandler.global.getRequestProcessors();
                for (int i = 0; i < states.length; ++i) {
                    if (states[i].getStage() != 3) continue;
                }
            }
            catch (Exception ex) {
                CoyoteLogger.HTTP_NIO_LOGGER.cannotDestroyHttpProtocolWithException(this.getName(), ex);
                throw ex;
            }
        }
        if (org.apache.tomcat.util.Constants.ENABLE_MODELER) {
            if (this.tpOname != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
            }
            if (this.rgOname != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
            }
        }
    }

    public String getJmxName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            encodedAddr = URLEncoder.encode(encodedAddr.replace('/', '-').replace(':', '_').replace('%', '-')) + "-";
        }
        return "http-" + encodedAddr + this.endpoint.getPort();
    }

    @Override
    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = NetworkUtils.formatIPAddressForURI(this.getAddress()) + ":";
        }
        return "http-" + encodedAddr + this.endpoint.getPort();
    }

    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.endpoint.setMaxThreads(maxThreads);
    }

    public void setPollerSize(int size) {
        this.endpoint.setMaxConnections(size);
    }

    public int getPollerSize() {
        return this.endpoint.getMaxConnections();
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.endpoint.setThreadPriority(threadPriority);
    }

    public int getBacklog() {
        return this.endpoint.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.endpoint.setBacklog(backlog);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int port) {
        this.endpoint.setPort(port);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.endpoint.setAddress(ia);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.endpoint.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.endpoint.getSoLinger();
    }

    public void setSoLinger(int soLinger) {
        this.endpoint.setSoLinger(soLinger);
    }

    public int getSoTimeout() {
        return this.endpoint.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.endpoint.setSoTimeout(soTimeout);
    }

    public boolean getReverseConnection() {
        return this.endpoint.isReverseConnection();
    }

    public void setReverseConnection(boolean reverseConnection) {
        this.endpoint.setReverseConnection(reverseConnection);
    }

    public boolean getDeferAccept() {
        return this.endpoint.getDeferAccept();
    }

    public void setDeferAccept(boolean deferAccept) {
        this.endpoint.setDeferAccept(deferAccept);
    }

    public int getKeepAliveTimeout() {
        return this.endpoint.getKeepAliveTimeout();
    }

    public void setKeepAliveTimeout(int timeout) {
        this.endpoint.setKeepAliveTimeout(timeout);
    }

    public boolean getUseSendfile() {
        return this.endpoint.getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
        this.endpoint.setUseSendfile(useSendfile);
    }

    public int getSendfileSize() {
        return this.endpoint.getSendfileSize();
    }

    public void setSendfileSize(int sendfileSize) {
        this.endpoint.setSendfileSize(sendfileSize);
    }

    public boolean getKeepAlive() {
        return this.maxKeepAliveRequests != 0 && this.maxKeepAliveRequests != 1;
    }

    public void setKeepAlive(boolean keepAlive) {
        if (!keepAlive) {
            this.setMaxKeepAliveRequests(1);
        }
    }

    public boolean isSSLEnabled() {
        return this.endpoint.getSSLEnabled();
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.endpoint.setSSLEnabled(SSLEnabled);
    }

    public String getSSLProtocol() {
        return this.endpoint.getSSLProtocol();
    }

    public void setSSLProtocol(String SSLProtocol) {
        this.endpoint.setSSLProtocol(SSLProtocol);
    }

    public String getSSLPassword() {
        return this.endpoint.getSSLPassword();
    }

    public void setSSLPassword(String SSLPassword) {
        this.endpoint.setSSLPassword(SSLPassword);
    }

    public String getSSLCipherSuite() {
        return this.endpoint.getSSLCipherSuite();
    }

    public void setSSLCipherSuite(String SSLCipherSuite) {
        this.endpoint.setSSLCipherSuite(SSLCipherSuite);
    }

    public String getSSLCertificateFile() {
        return this.endpoint.getSSLCertificateFile();
    }

    public void setSSLCertificateFile(String SSLCertificateFile) {
        this.endpoint.setSSLCertificateFile(SSLCertificateFile);
    }

    public String getSSLCertificateKeyFile() {
        return this.endpoint.getSSLCertificateKeyFile();
    }

    public void setSSLCertificateKeyFile(String SSLCertificateKeyFile) {
        this.endpoint.setSSLCertificateKeyFile(SSLCertificateKeyFile);
    }

    public String getSSLCertificateChainFile() {
        return this.endpoint.getSSLCertificateChainFile();
    }

    public void setSSLCertificateChainFile(String SSLCertificateChainFile) {
        this.endpoint.setSSLCertificateChainFile(SSLCertificateChainFile);
    }

    public String getSSLCACertificatePath() {
        return this.endpoint.getSSLCACertificatePath();
    }

    public void setSSLCACertificatePath(String SSLCACertificatePath) {
        this.endpoint.setSSLCACertificatePath(SSLCACertificatePath);
    }

    public String getSSLCACertificateFile() {
        return this.endpoint.getSSLCACertificateFile();
    }

    public void setSSLCACertificateFile(String SSLCACertificateFile) {
        this.endpoint.setSSLCACertificateFile(SSLCACertificateFile);
    }

    public String getSSLCARevocationPath() {
        return this.endpoint.getSSLCARevocationPath();
    }

    public void setSSLCARevocationPath(String SSLCARevocationPath) {
        this.endpoint.setSSLCARevocationPath(SSLCARevocationPath);
    }

    public String getSSLCARevocationFile() {
        return this.endpoint.getSSLCARevocationFile();
    }

    public void setSSLCARevocationFile(String SSLCARevocationFile) {
        this.endpoint.setSSLCARevocationFile(SSLCARevocationFile);
    }

    public String getSSLVerifyClient() {
        return this.endpoint.getSSLVerifyClient();
    }

    public void setSSLVerifyClient(String SSLVerifyClient) {
        this.endpoint.setSSLVerifyClient(SSLVerifyClient);
    }

    public int getSSLVerifyDepth() {
        return this.endpoint.getSSLVerifyDepth();
    }

    public void setSSLVerifyDepth(int SSLVerifyDepth) {
        this.endpoint.setSSLVerifyDepth(SSLVerifyDepth);
    }

    static class Http11ConnectionHandler
    implements NioEndpoint.Handler {
        protected Http11NioProtocol proto;
        protected AtomicLong registerCount = new AtomicLong(0L);
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected ConcurrentHashMap<Long, Http11NioProcessor> connections = new ConcurrentHashMap();
        protected ConcurrentLinkedQueue<Http11NioProcessor> recycledProcessors = new ConcurrentLinkedQueue<Http11NioProcessor>(){
            private static final long serialVersionUID = 1L;
            protected AtomicInteger size = new AtomicInteger(0);

            @Override
            public boolean offer(Http11NioProcessor processor) {
                boolean offer = Http11ConnectionHandler.this.proto.processorCache == -1 ? true : this.size.get() < Http11ConnectionHandler.this.proto.processorCache;
                boolean result = false;
                if (offer && (result = super.offer(processor))) {
                    this.size.incrementAndGet();
                }
                if (!result) {
                    Http11ConnectionHandler.this.unregister(processor);
                }
                return result;
            }

            @Override
            public Http11NioProcessor poll() {
                Http11NioProcessor result = (Http11NioProcessor)super.poll();
                if (result != null) {
                    this.size.decrementAndGet();
                }
                return result;
            }

            @Override
            public void clear() {
                Http11NioProcessor next = this.poll();
                while (next != null) {
                    Http11ConnectionHandler.this.unregister(next);
                    next = this.poll();
                }
                super.clear();
                this.size.set(0);
            }
        };

        Http11ConnectionHandler(Http11NioProtocol proto) {
            this.proto = proto;
        }

        /*
         * Exception decompiling
         */
        @Override
        public NioEndpoint.Handler.SocketState event(NioChannel channel, SocketStatus status) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NioEndpoint.Handler.SocketState process(NioChannel channel) {
            Http11NioProcessor processor = this.recycledProcessors.poll();
            if (processor == null) {
                processor = this.createProcessor();
            }
            Request request = processor.getRequest();
            synchronized (request) {
                try {
                    processor.startProcessing();
                    if (this.proto.secure && this.proto.sslImplementation != null) {
                        processor.setSSLSupport(((NioJSSEImplementation)this.proto.sslImplementation).getSSLSupport(channel));
                    } else {
                        processor.setSSLSupport(null);
                    }
                    NioEndpoint.Handler.SocketState state = processor.process(channel);
                    if (state == NioEndpoint.Handler.SocketState.LONG) {
                        this.connections.put(channel.getId(), processor);
                        if (processor.isAvailable() && processor.getReadNotifications()) {
                            state = this.event(channel, SocketStatus.OPEN_READ);
                            processor.endProcessing();
                        } else {
                            Http11NioProcessor http11NioProcessor = processor;
                            synchronized (http11NioProcessor) {
                                this.proto.endpoint.addEventChannel(channel, processor.getTimeout(), processor.getReadNotifications(), false, processor.getResumeNotification(), false);
                                processor.endProcessing();
                            }
                        }
                    } else {
                        this.recycledProcessors.offer(processor);
                        processor.endProcessing();
                    }
                    return state;
                }
                catch (IOException e) {
                    if (e instanceof SocketException) {
                        CoyoteLogger.HTTP_NIO_LOGGER.socketException(e);
                    } else {
                        CoyoteLogger.HTTP_NIO_LOGGER.socketException(e);
                    }
                }
                catch (Throwable e) {
                    CoyoteLogger.HTTP_NIO_LOGGER.socketError(e);
                }
                processor.endProcessing();
            }
            this.recycledProcessors.offer(processor);
            return NioEndpoint.Handler.SocketState.CLOSED;
        }

        protected Http11NioProcessor createProcessor() {
            Http11NioProcessor processor = new Http11NioProcessor(this.proto.maxHttpHeaderSize, this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setMaxKeepAliveRequests(this.proto.maxKeepAliveRequests);
            processor.setTimeout(this.proto.timeout);
            processor.setDisableUploadTimeout(this.proto.disableUploadTimeout);
            processor.setCompressionMinSize(this.proto.compressionMinSize);
            processor.setCompression(this.proto.compression);
            processor.setNoCompressionUserAgents(this.proto.noCompressionUserAgents);
            processor.setCompressableMimeTypes(this.proto.compressableMimeTypes);
            processor.setRestrictedUserAgents(this.proto.restrictedUserAgents);
            processor.setMaxSavePostSize(this.proto.maxSavePostSize);
            processor.setServer(this.proto.server);
            this.register(processor);
            return processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(Http11NioProcessor processor) {
            RequestInfo rp = processor.getRequest().getRequestProcessor();
            rp.setGlobalProcessor(this.global);
            if (org.apache.tomcat.util.Constants.ENABLE_MODELER && this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getJmxName() + ",name=HttpRequest" + count);
                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        rp.setRpName(rpName);
                    }
                    catch (Exception e) {
                        CoyoteLogger.HTTP_NIO_LOGGER.errorRegisteringRequest(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(Http11NioProcessor processor) {
            RequestInfo rp = processor.getRequest().getRequestProcessor();
            rp.setGlobalProcessor(null);
            if (org.apache.tomcat.util.Constants.ENABLE_MODELER && this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        ObjectName rpName = rp.getRpName();
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        CoyoteLogger.HTTP_NIO_LOGGER.errorUnregisteringRequest(e);
                    }
                }
            }
        }
    }
}

