/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.coyote.Adapter;
import org.apache.coyote.Constants;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.Request;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.Http11AprProcessor;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.jboss.web.CoyoteLogger;
import org.jboss.web.NetworkUtils;

public class Http11AprProtocol
implements ProtocolHandler,
MBeanRegistration {
    protected Adapter adapter;
    private boolean canDestroy = false;
    ObjectName tpOname;
    ObjectName rgOname;
    protected AprEndpoint endpoint = new AprEndpoint();
    protected HashMap<String, Object> attributes = new HashMap();
    private Http11ConnectionHandler cHandler = new Http11ConnectionHandler(this);
    protected int processorCache = -1;
    protected int socketBuffer = 9000;
    protected int maxSavePostSize = 4096;
    protected int maxHttpHeaderSize = Integer.valueOf(System.getProperty("org.apache.coyote.http11.Http11Protocol.MAX_HEADER_SIZE", "8192"));
    protected boolean disableUploadTimeout = org.apache.coyote.http11.Constants.DEFAULT_DISABLE_UPLOAD_TIMEOUT;
    protected String compression = System.getProperty("org.apache.coyote.http11.Http11Protocol.COMPRESSION", "off");
    protected String noCompressionUserAgents = System.getProperty("org.apache.coyote.http11.Http11Protocol.COMPRESSION_RESTRICTED_UA");
    protected String compressableMimeTypes = System.getProperty("org.apache.coyote.http11.Http11Protocol.COMPRESSION_MIME_TYPES", "text/html,text/xml,text/plain");
    protected int compressionMinSize = Integer.valueOf(System.getProperty("org.apache.coyote.http11.Http11Protocol.COMPRESSION_MIN_SIZE", "2048"));
    protected String restrictedUserAgents = null;
    protected String protocol = null;
    protected int maxKeepAliveRequests = Integer.valueOf(System.getProperty("org.apache.coyote.http11.Http11Protocol.MAX_KEEP_ALIVE_REQUESTS", "-1"));
    protected String server = System.getProperty("org.apache.coyote.http11.Http11Protocol.SERVER");
    protected int timeout = 300000;
    protected boolean secure;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public Http11AprProtocol() {
        this.setSoLinger(-1);
        this.setSoTimeout(org.apache.coyote.http11.Constants.DEFAULT_CONNECTION_TIMEOUT);
        this.setTcpNoDelay(true);
        this.setKeepAliveTimeout(org.apache.coyote.http11.Constants.DEFAULT_KEEP_ALIVE_TIMEOUT);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    @Override
    public boolean hasIoEvents() {
        return true;
    }

    @Override
    public RequestGroupInfo getRequestGroupInfo() {
        return this.cHandler.global;
    }

    @Override
    public void init() throws Exception {
        this.endpoint.setName(this.getName());
        this.endpoint.setHandler(this.cHandler);
        try {
            this.endpoint.init();
        }
        catch (Exception ex) {
            CoyoteLogger.HTTP_APR_LOGGER.errorInitializingEndpoint(ex);
            throw ex;
        }
        CoyoteLogger.HTTP_APR_LOGGER.initHttpConnector(this.getName());
    }

    @Override
    public void start() throws Exception {
        if (org.apache.tomcat.util.Constants.ENABLE_MODELER && this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getJmxName());
                Registry.getRegistry(null, null).registerComponent((Object)this.endpoint, this.tpOname, null);
            }
            catch (Exception e) {
                CoyoteLogger.HTTP_APR_LOGGER.errorRegisteringPool(e);
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getJmxName());
            Registry.getRegistry(null, null).registerComponent((Object)this.cHandler.global, this.rgOname, null);
        }
        try {
            this.endpoint.start();
        }
        catch (Exception ex) {
            CoyoteLogger.HTTP_APR_LOGGER.errorStartingEndpoint(ex);
            throw ex;
        }
        CoyoteLogger.HTTP_APR_LOGGER.startHttpConnector(this.getName());
    }

    @Override
    public void pause() throws Exception {
        try {
            this.endpoint.pause();
        }
        catch (Exception ex) {
            CoyoteLogger.HTTP_APR_LOGGER.errorPausingEndpoint(ex);
            throw ex;
        }
        this.canDestroy = false;
        RequestInfo[] states = this.cHandler.global.getRequestProcessors();
        int retry = 0;
        boolean done = false;
        while (!done && retry < Constants.MAX_PAUSE_WAIT) {
            ++retry;
            done = true;
            for (int i = 0; i < states.length; ++i) {
                if (states[i].getStage() != 3) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                done = false;
                break;
            }
            if (!done) continue;
            this.canDestroy = true;
        }
        CoyoteLogger.HTTP_APR_LOGGER.pauseHttpConnector(this.getName());
    }

    @Override
    public void resume() throws Exception {
        try {
            this.endpoint.resume();
        }
        catch (Exception ex) {
            CoyoteLogger.HTTP_APR_LOGGER.errorResumingEndpoint(ex);
            throw ex;
        }
        CoyoteLogger.HTTP_APR_LOGGER.resumeHttpConnector(this.getName());
    }

    @Override
    public void destroy() throws Exception {
        CoyoteLogger.HTTP_APR_LOGGER.stopHttpConnector(this.getName());
        if (this.canDestroy) {
            this.endpoint.destroy();
        } else {
            CoyoteLogger.HTTP_APR_LOGGER.cannotDestroyHttpProtocol(this.getName());
            try {
                RequestInfo[] states = this.cHandler.global.getRequestProcessors();
                for (int i = 0; i < states.length; ++i) {
                    if (states[i].getStage() != 3) continue;
                }
            }
            catch (Exception ex) {
                CoyoteLogger.HTTP_APR_LOGGER.cannotDestroyHttpProtocolWithException(this.getName(), ex);
                throw ex;
            }
        }
        if (org.apache.tomcat.util.Constants.ENABLE_MODELER) {
            if (this.tpOname != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
            }
            if (this.rgOname != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
            }
        }
    }

    public String getJmxName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            encodedAddr = URLEncoder.encode(encodedAddr.replace('/', '-').replace(':', '_').replace('%', '-')) + "-";
        }
        return "http-" + encodedAddr + this.endpoint.getPort();
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = NetworkUtils.formatIPAddressForURI(this.getAddress()) + ":";
        }
        return "http-" + encodedAddr + this.endpoint.getPort();
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int processorCache) {
        this.processorCache = processorCache;
    }

    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.endpoint.setMaxThreads(maxThreads);
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.endpoint.setThreadPriority(threadPriority);
    }

    public int getBacklog() {
        return this.endpoint.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.endpoint.setBacklog(backlog);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int port) {
        this.endpoint.setPort(port);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.endpoint.setAddress(ia);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.endpoint.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.endpoint.getSoLinger();
    }

    public void setSoLinger(int soLinger) {
        this.endpoint.setSoLinger(soLinger);
    }

    public int getSoTimeout() {
        return this.endpoint.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.endpoint.setSoTimeout(soTimeout);
    }

    public boolean getReverseConnection() {
        return this.endpoint.isReverseConnection();
    }

    public void setReverseConnection(boolean reverseConnection) {
        this.endpoint.setReverseConnection(reverseConnection);
    }

    public boolean getDeferAccept() {
        return this.endpoint.getDeferAccept();
    }

    public void setDeferAccept(boolean deferAccept) {
        this.endpoint.setDeferAccept(deferAccept);
    }

    public int getKeepAliveTimeout() {
        return this.endpoint.getKeepAliveTimeout();
    }

    public void setKeepAliveTimeout(int timeout) {
        this.endpoint.setKeepAliveTimeout(timeout);
    }

    public boolean getUseSendfile() {
        return this.endpoint.getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
        this.endpoint.setUseSendfile(useSendfile);
    }

    public int getPollTime() {
        return this.endpoint.getPollTime();
    }

    public void setPollTime(int pollTime) {
        this.endpoint.setPollTime(pollTime);
    }

    public void setPollerSize(int pollerSize) {
        this.endpoint.setPollerSize(pollerSize);
    }

    public int getPollerSize() {
        return this.endpoint.getPollerSize();
    }

    public int getSendfileSize() {
        return this.endpoint.getSendfileSize();
    }

    public void setSendfileSize(int sendfileSize) {
        this.endpoint.setSendfileSize(sendfileSize);
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setSocketBuffer(int socketBuffer) {
        this.socketBuffer = socketBuffer;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int valueI) {
        this.maxSavePostSize = valueI;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int valueI) {
        this.maxHttpHeaderSize = valueI;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String valueS) {
        this.compression = valueS;
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String valueS) {
        this.noCompressionUserAgents = valueS;
    }

    public String getCompressableMimeType() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeType(String valueS) {
        this.compressableMimeTypes = valueS;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int valueI) {
        this.compressionMinSize = valueI;
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String valueS) {
        this.restrictedUserAgents = valueS;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.setSecure(true);
        this.protocol = protocol;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public boolean getKeepAlive() {
        return this.maxKeepAliveRequests != 0 && this.maxKeepAliveRequests != 1;
    }

    public void setKeepAlive(boolean keepAlive) {
        if (!keepAlive) {
            this.setMaxKeepAliveRequests(1);
        }
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.secure = b;
    }

    public boolean isSSLEnabled() {
        return this.endpoint.isSSLEnabled();
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.endpoint.setSSLEnabled(SSLEnabled);
    }

    public String getSSLProtocol() {
        return this.endpoint.getSSLProtocol();
    }

    public void setSSLProtocol(String SSLProtocol) {
        this.endpoint.setSSLProtocol(SSLProtocol);
    }

    public String getSSLPassword() {
        return this.endpoint.getSSLPassword();
    }

    public void setSSLPassword(String SSLPassword) {
        this.endpoint.setSSLPassword(SSLPassword);
    }

    public String getSSLCipherSuite() {
        return this.endpoint.getSSLCipherSuite();
    }

    public void setSSLCipherSuite(String SSLCipherSuite) {
        this.endpoint.setSSLCipherSuite(SSLCipherSuite);
    }

    public String getSSLCertificateFile() {
        return this.endpoint.getSSLCertificateFile();
    }

    public void setSSLCertificateFile(String SSLCertificateFile) {
        this.endpoint.setSSLCertificateFile(SSLCertificateFile);
    }

    public String getSSLCertificateKeyFile() {
        return this.endpoint.getSSLCertificateKeyFile();
    }

    public void setSSLCertificateKeyFile(String SSLCertificateKeyFile) {
        this.endpoint.setSSLCertificateKeyFile(SSLCertificateKeyFile);
    }

    public String getSSLCertificateChainFile() {
        return this.endpoint.getSSLCertificateChainFile();
    }

    public void setSSLCertificateChainFile(String SSLCertificateChainFile) {
        this.endpoint.setSSLCertificateChainFile(SSLCertificateChainFile);
    }

    public String getSSLCACertificatePath() {
        return this.endpoint.getSSLCACertificatePath();
    }

    public void setSSLCACertificatePath(String SSLCACertificatePath) {
        this.endpoint.setSSLCACertificatePath(SSLCACertificatePath);
    }

    public String getSSLCACertificateFile() {
        return this.endpoint.getSSLCACertificateFile();
    }

    public void setSSLCACertificateFile(String SSLCACertificateFile) {
        this.endpoint.setSSLCACertificateFile(SSLCACertificateFile);
    }

    public String getSSLCARevocationPath() {
        return this.endpoint.getSSLCARevocationPath();
    }

    public void setSSLCARevocationPath(String SSLCARevocationPath) {
        this.endpoint.setSSLCARevocationPath(SSLCARevocationPath);
    }

    public String getSSLCARevocationFile() {
        return this.endpoint.getSSLCARevocationFile();
    }

    public void setSSLCARevocationFile(String SSLCARevocationFile) {
        this.endpoint.setSSLCARevocationFile(SSLCARevocationFile);
    }

    public String getSSLVerifyClient() {
        return this.endpoint.getSSLVerifyClient();
    }

    public void setSSLVerifyClient(String SSLVerifyClient) {
        this.endpoint.setSSLVerifyClient(SSLVerifyClient);
    }

    public int getSSLVerifyDepth() {
        return this.endpoint.getSSLVerifyDepth();
    }

    public void setSSLVerifyDepth(int SSLVerifyDepth) {
        this.endpoint.setSSLVerifyDepth(SSLVerifyDepth);
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    static class Http11ConnectionHandler
    implements AprEndpoint.Handler {
        protected Http11AprProtocol proto;
        protected AtomicLong registerCount = new AtomicLong(0L);
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected ConcurrentHashMap<Long, Http11AprProcessor> connections = new ConcurrentHashMap();
        protected ConcurrentLinkedQueue<Http11AprProcessor> recycledProcessors = new ConcurrentLinkedQueue<Http11AprProcessor>(){
            protected AtomicInteger size = new AtomicInteger(0);

            @Override
            public boolean offer(Http11AprProcessor processor) {
                boolean offer = Http11ConnectionHandler.this.proto.processorCache == -1 ? true : this.size.get() < Http11ConnectionHandler.this.proto.processorCache;
                boolean result = false;
                if (offer && (result = super.offer(processor))) {
                    this.size.incrementAndGet();
                }
                if (!result) {
                    Http11ConnectionHandler.this.unregister(processor);
                }
                return result;
            }

            @Override
            public Http11AprProcessor poll() {
                Http11AprProcessor result = (Http11AprProcessor)super.poll();
                if (result != null) {
                    this.size.decrementAndGet();
                }
                return result;
            }

            @Override
            public void clear() {
                Http11AprProcessor next = this.poll();
                while (next != null) {
                    Http11ConnectionHandler.this.unregister(next);
                    next = this.poll();
                }
                super.clear();
                this.size.set(0);
            }
        };

        Http11ConnectionHandler(Http11AprProtocol proto) {
            this.proto = proto;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AprEndpoint.Handler.SocketState event(long socket, SocketStatus status) {
            Http11AprProcessor result = this.connections.get(socket);
            AprEndpoint.Handler.SocketState state = AprEndpoint.Handler.SocketState.CLOSED;
            if (result != null) {
                Request request = result.getRequest();
                synchronized (request) {
                    result.startProcessing();
                    try {
                        state = result.event(status);
                    }
                    catch (SocketException e) {
                        CoyoteLogger.HTTP_APR_LOGGER.socketException(e);
                    }
                    catch (IOException e) {
                        CoyoteLogger.HTTP_APR_LOGGER.socketException(e);
                    }
                    catch (Throwable e) {
                        CoyoteLogger.HTTP_APR_LOGGER.socketError(e);
                    }
                    finally {
                        if (state != AprEndpoint.Handler.SocketState.LONG) {
                            this.connections.remove(socket);
                            this.recycledProcessors.offer(result);
                            if (this.proto.endpoint.isRunning() && state == AprEndpoint.Handler.SocketState.OPEN) {
                                this.proto.endpoint.getPoller().add(socket);
                            }
                        } else if (this.proto.endpoint.isRunning()) {
                            this.proto.endpoint.getEventPoller().add(socket, result.getTimeout(), result.getReadNotifications(), result.getWriteNotification(), result.getResumeNotification(), false);
                        }
                        result.endProcessing();
                    }
                }
            }
            return state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AprEndpoint.Handler.SocketState process(long socket) {
            Http11AprProcessor processor = this.recycledProcessors.poll();
            if (processor == null) {
                processor = this.createProcessor();
            }
            Request request = processor.getRequest();
            synchronized (request) {
                try {
                    AprEndpoint.Handler.SocketState state = processor.process(socket);
                    if (state == AprEndpoint.Handler.SocketState.LONG) {
                        this.connections.put(socket, processor);
                        if (processor.getAvailable() && processor.getReadNotifications()) {
                            state = this.event(socket, SocketStatus.OPEN_READ);
                        } else {
                            this.proto.endpoint.getEventPoller().add(socket, processor.getTimeout(), processor.getReadNotifications(), false, processor.getResumeNotification(), false);
                        }
                    } else {
                        this.recycledProcessors.offer(processor);
                    }
                    return state;
                }
                catch (SocketException e) {
                    CoyoteLogger.HTTP_APR_LOGGER.socketException(e);
                }
                catch (IOException e) {
                    CoyoteLogger.HTTP_APR_LOGGER.socketException(e);
                }
                catch (Throwable e) {
                    CoyoteLogger.HTTP_APR_LOGGER.socketError(e);
                }
            }
            this.recycledProcessors.offer(processor);
            return AprEndpoint.Handler.SocketState.CLOSED;
        }

        protected Http11AprProcessor createProcessor() {
            Http11AprProcessor processor = new Http11AprProcessor(this.proto.maxHttpHeaderSize, this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setMaxKeepAliveRequests(this.proto.maxKeepAliveRequests);
            processor.setTimeout(this.proto.timeout);
            processor.setDisableUploadTimeout(this.proto.disableUploadTimeout);
            processor.setCompressionMinSize(this.proto.compressionMinSize);
            processor.setCompression(this.proto.compression);
            processor.setNoCompressionUserAgents(this.proto.noCompressionUserAgents);
            processor.setCompressableMimeTypes(this.proto.compressableMimeTypes);
            processor.setRestrictedUserAgents(this.proto.restrictedUserAgents);
            processor.setSocketBuffer(this.proto.socketBuffer);
            processor.setMaxSavePostSize(this.proto.maxSavePostSize);
            processor.setServer(this.proto.server);
            this.register(processor);
            return processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(Http11AprProcessor processor) {
            RequestInfo rp = processor.getRequest().getRequestProcessor();
            rp.setGlobalProcessor(this.global);
            if (org.apache.tomcat.util.Constants.ENABLE_MODELER && this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getJmxName() + ",name=HttpRequest" + count);
                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        rp.setRpName(rpName);
                    }
                    catch (Exception e) {
                        CoyoteLogger.HTTP_APR_LOGGER.errorRegisteringRequest(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(Http11AprProcessor processor) {
            RequestInfo rp = processor.getRequest().getRequestProcessor();
            rp.setGlobalProcessor(null);
            if (org.apache.tomcat.util.Constants.ENABLE_MODELER && this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        ObjectName rpName = rp.getRpName();
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        CoyoteLogger.HTTP_APR_LOGGER.errorUnregisteringRequest(e);
                    }
                }
            }
        }
    }
}

