/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.apache.tomcat.util.buf.Utf8Decoder;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.web.CatalinaMessages;

public class WsFrame {
    private final boolean fin;
    private final int rsv;
    private final byte opCode;
    private final byte[] mask = new byte[4];
    private long payloadLength;
    private final ByteBuffer payload;

    private WsFrame(byte first, HttpEvent event) throws IOException {
        byte[] extended;
        int b = first & 0xFF;
        this.fin = (b & 0x80) > 0;
        this.rsv = (b & 0x70) >>> 4;
        this.opCode = (byte)(b & 0xF);
        b = this.blockingRead(event);
        if ((b & 0x80) == 0) {
            throw new IOException(CatalinaMessages.MESSAGES.frameNotMasked());
        }
        this.payloadLength = b & 0x7F;
        if (this.payloadLength == 126L) {
            extended = new byte[2];
            this.blockingRead(event, extended);
            this.payloadLength = WsFrame.byteArrayToLong(extended);
        } else if (this.payloadLength == 127L) {
            extended = new byte[8];
            this.blockingRead(event, extended);
            this.payloadLength = WsFrame.byteArrayToLong(extended);
        }
        if (this.isControl()) {
            if (this.payloadLength > 125L) {
                throw new IOException();
            }
            if (!this.fin) {
                throw new IOException();
            }
        }
        if (this.payloadLength < 0L) {
            throw new IOException(CatalinaMessages.MESSAGES.frameinvalidLength());
        }
        this.blockingRead(event, this.mask);
        if (this.isControl()) {
            this.payload = ByteBuffer.allocate((int)this.payloadLength);
            this.blockingRead(event, this.payload);
            if (this.opCode == 8 && this.payloadLength > 2L) {
                CharBuffer cb = CharBuffer.allocate((int)this.payloadLength);
                Utf8Decoder decoder = new Utf8Decoder();
                this.payload.position(2);
                CoderResult cr = decoder.decode(this.payload, cb, true);
                this.payload.position(0);
                if (cr.isError()) {
                    throw new IOException(CatalinaMessages.MESSAGES.frameInvalidUtf8());
                }
            }
        } else {
            this.payload = null;
        }
    }

    public static long byteArrayToLong(byte[] input) throws IOException {
        if (input.length > 8) {
            throw new IOException();
        }
        int shift = 0;
        long result = 0L;
        for (int i = input.length - 1; i >= 0; --i) {
            result += (long)((input[i] & 0xFF) << shift);
            shift += 8;
        }
        return result;
    }

    public boolean getFin() {
        return this.fin;
    }

    public int getRsv() {
        return this.rsv;
    }

    public byte getOpCode() {
        return this.opCode;
    }

    public boolean isControl() {
        return (this.opCode & 8) > 0;
    }

    public byte[] getMask() {
        return this.mask;
    }

    public long getPayLoadLength() {
        return this.payloadLength;
    }

    public ByteBuffer getPayLoad() {
        return this.payload;
    }

    private int blockingRead(HttpEvent event) throws IOException {
        int result = event.getHttpServletRequest().getInputStream().read();
        if (result == -1) {
            throw new IOException(CatalinaMessages.MESSAGES.frameEos());
        }
        return result;
    }

    private void blockingRead(HttpEvent event, byte[] bytes) throws IOException {
        int last = 0;
        for (int read = 0; read < bytes.length; read += last) {
            last = event.getHttpServletRequest().getInputStream().read(bytes, read, bytes.length - read);
            if (last != -1) continue;
            throw new IOException(CatalinaMessages.MESSAGES.frameEos());
        }
    }

    private void blockingRead(HttpEvent event, ByteBuffer bb) throws IOException {
        int last = 0;
        while (bb.hasRemaining()) {
            last = event.getHttpServletRequest().getInputStream().read();
            if (last == -1) {
                throw new IOException(CatalinaMessages.MESSAGES.frameEos());
            }
            bb.put((byte)(last ^ this.mask[bb.position() % 4]));
        }
        bb.flip();
    }

    public static WsFrame nextFrame(HttpEvent event, boolean block) throws IOException {
        byte[] first = new byte[1];
        int read = 0;
        if (block) {
            read = event.getHttpServletRequest().getInputStream().read(first, 0, 1);
        } else if (event.isReadReady()) {
            read = event.getHttpServletRequest().getInputStream().read(first, 0, 1);
        }
        if (read == 1) {
            return new WsFrame(first[0], event);
        }
        if (read == 0) {
            return null;
        }
        if (read == -1) {
            throw new EOFException(CatalinaMessages.MESSAGES.frameEos());
        }
        throw new IOException(CatalinaMessages.MESSAGES.frameFailedRead(read));
    }
}

