/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.jboss.web.CatalinaMessages;

public class AsyncContextImpl
implements AsyncContext {
    protected Request request;
    protected ServletRequest servletRequest = null;
    protected ServletResponse servletResponse = null;
    protected ServletContext servletContext = null;
    protected String path = null;
    protected Runnable runnable = null;
    protected Throwable error = null;
    protected boolean useAttributes = false;
    protected boolean original = true;
    protected boolean ready = true;

    public AsyncContextImpl(Request request) {
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        if (this.request == null) {
            return;
        }
        org.apache.coyote.Request request = this.request.getCoyoteRequest();
        synchronized (request) {
            if (this.request != null) {
                this.request.setEventMode(false);
                this.request.wakeup();
            }
        }
    }

    public void dispatch() {
        this.servletContext = null;
        if (this.servletRequest == this.request.getRequestFacade()) {
            this.path = this.request.getRequestPathMB().toString();
        } else if (this.servletRequest instanceof HttpServletRequest) {
            String requestURI = ((HttpServletRequest)this.servletRequest).getRequestURI();
            this.servletContext = this.request.getServletContext0().getContext(requestURI);
            if (this.servletContext != null) {
                this.path = requestURI.substring(this.servletContext.getContextPath().length());
            } else {
                throw CatalinaMessages.MESSAGES.cannotFindDispatchContext(requestURI);
            }
        }
        if (this.request == null) {
            return;
        }
        this.request.wakeup();
    }

    public void dispatch(String path) {
        this.servletContext = null;
        this.path = path;
        this.useAttributes = true;
        if (this.request == null) {
            return;
        }
        this.request.wakeup();
    }

    public void dispatch(ServletContext servletContext, String path) {
        this.servletContext = servletContext;
        this.path = path;
        this.useAttributes = true;
        if (this.request == null) {
            return;
        }
        this.request.wakeup();
    }

    public ServletRequest getRequest() {
        if (this.servletRequest != null) {
            return this.servletRequest;
        }
        return this.request.getRequestFacade();
    }

    public ServletResponse getResponse() {
        if (this.servletResponse != null) {
            return this.servletResponse;
        }
        return this.request.getResponseFacade();
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.servletRequest == this.request.getRequestFacade() && this.servletResponse == this.request.getResponseFacade();
    }

    public void start(Runnable runnable) {
        this.runnable = runnable;
        if (this.request == null) {
            return;
        }
        this.request.wakeup();
    }

    public boolean isReady() {
        return this.ready;
    }

    public void done() {
        this.ready = false;
    }

    public void setRequestAndResponse(ServletRequest servletRequest, ServletResponse servletResponse) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getUseAttributes() {
        return this.useAttributes;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public Runnable runRunnable() {
        Runnable result = this.runnable;
        this.runnable = null;
        return result;
    }

    public void reset() {
        this.servletContext = null;
        this.path = null;
        this.runnable = null;
        this.useAttributes = false;
        this.ready = true;
        this.error = null;
    }

    public Map<AsyncListener, AsyncListenerRegistration> getAsyncListeners() {
        return this.request.getAsyncListeners();
    }

    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        this.getAsyncListeners().put(listener, new AsyncListenerRegistration(listener, servletRequest, servletResponse));
    }

    public void addListener(AsyncListener listener) {
        this.addListener(listener, this.getRequest(), (ServletResponse)this.request.getResponse().getResponse());
    }

    public long getTimeout() {
        return this.request.getAsyncTimeout();
    }

    public void setTimeout(long timeout) {
        int realTimeout;
        if (this.request == null) {
            return;
        }
        this.request.setAsyncTimeout(timeout);
        int n = realTimeout = timeout > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeout;
        if (realTimeout <= 0) {
            realTimeout = Integer.MAX_VALUE;
        }
        this.request.setTimeout0(realTimeout);
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        AsyncListener listenerInstance = null;
        try {
            listenerInstance = (AsyncListener)this.request.getContext().getInstanceManager().newInstance(clazz);
        }
        catch (Exception e) {
            throw new ServletException(CatalinaMessages.MESSAGES.listenerCreationFailed(clazz.getName()), (Throwable)e);
        }
        this.request.getAsyncListenerInstances().add(listenerInstance);
        return (T)listenerInstance;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.ready = true;
        this.error = error;
    }

    public void clear() {
        this.reset();
        this.request = null;
    }

    public class AsyncListenerRegistration {
        protected ServletRequest request;
        protected ServletResponse response;
        protected AsyncListener listener;

        protected AsyncListenerRegistration(AsyncListener listener, ServletRequest request, ServletResponse response) {
            this.listener = listener;
            this.request = request;
            this.response = response;
        }

        public ServletRequest getRequest() {
            return this.request;
        }

        public ServletResponse getResponse() {
            return this.response;
        }

        public AsyncListener getListener() {
            return this.listener;
        }
    }
}

