/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.apache.catalina.connector.Connector;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class WebConnectorMetrics
implements OperationStepHandler {
    static WebConnectorMetrics INSTANCE = new WebConnectorMetrics();
    protected static final SimpleAttributeDefinition BYTES_SENT = new SimpleAttributeDefinitionBuilder("bytesSent", ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition BYTES_RECEIVED = new SimpleAttributeDefinitionBuilder("bytesReceived", ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition PROCESSING_TIME = new SimpleAttributeDefinitionBuilder("processingTime", ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition ERROR_COUNT = new SimpleAttributeDefinitionBuilder("errorCount", ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition MAX_TIME = new SimpleAttributeDefinitionBuilder("maxTime", ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition REQUEST_COUNT = new SimpleAttributeDefinitionBuilder("requestCount", ModelType.INT, true).setStorageRuntime().build();
    @Deprecated
    static final String[] ATTRIBUTES_OLD = new String[]{"bytesSent", "bytesReceived", "processingTime", "errorCount", "maxTime", "requestCount"};
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{BYTES_SENT, BYTES_RECEIVED, PROCESSING_TIME, ERROR_COUNT, MAX_TIME, REQUEST_COUNT};

    WebConnectorMetrics() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                /*
                 * Unable to fully structure code
                 */
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    name = address.getLastElement().getValue();
                    attributeName = operation.require("name").asString();
                    controller = context.getServiceRegistry(false).getService(WebSubsystemServices.JBOSS_WEB_CONNECTOR.append(new String[]{name}));
                    if (controller != null) {
                        try {
                            connector = (Connector)controller.getValue();
                            result = context.getResult();
                            if (connector.getProtocolHandler() == null || connector.getProtocolHandler().getRequestGroupInfo() == null) ** GOTO lbl39
                            info = connector.getProtocolHandler().getRequestGroupInfo();
                            if ("bytesSent".equals(attributeName)) {
                                result.set((int)info.getBytesSent());
                            }
                            if ("bytesReceived".equals(attributeName)) {
                                result.set((int)info.getBytesReceived());
                            }
                            if ("processingTime".equals(attributeName)) {
                                result.set((int)info.getProcessingTime());
                            }
                            if ("errorCount".equals(attributeName)) {
                                result.set(info.getErrorCount());
                            }
                            if ("maxTime".equals(attributeName)) {
                                result.set((int)info.getMaxTime());
                            }
                            if (!"requestCount".equals(attributeName)) ** GOTO lbl39
                            result.set(info.getRequestCount());
                        }
                        catch (Exception e) {
                            throw new OperationFailedException(new ModelNode().set(WebMessages.MESSAGES.failedToGetMetrics(e.getMessage())));
                        }
                    } else {
                        context.getResult().set(WebMessages.MESSAGES.noMetricsAvailable());
                    }
lbl39:
                    // 9 sources

                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        } else {
            context.getResult().set(WebMessages.MESSAGES.noMetricsAvailable());
        }
        context.stepCompleted();
    }
}

